package net.minecraft.client.option.options

import net.minecraft.client.MinecraftInstance
import net.minecraft.client.option.OptionManager
import net.optifine.shaders.Shaders
import net.optifine.shaders.ShadersTex

object ActionQueue: MinecraftInstance() {

    var isNeedMinecraftScheduledRefreshResources = false
    var isNeedMinecraftRefreshResources = false
    var isNeedMinecraftLoadRenderers = false
    var isNeedRefreshChat = false
    var isNeedMinecraftReloadSkinSetting = false
    var isNeedShaderUninit = false
    var isNeedScheduleResize = false
    var isNeedScheduleResizeShadow = false
    var isNeedShaderUpdateMinMag = false

    fun applyAction() {
        if (isNeedShaderUninit)
            Shaders.uninit()

        if (isNeedScheduleResize)
            Shaders.scheduleResize()
        else if (isNeedScheduleResizeShadow)
            Shaders.scheduleResizeShadow()

        if (isNeedShaderUpdateMinMag)
            ShadersTex.updateTextureMinMagFilter()

        if (isNeedMinecraftScheduledRefreshResources)
            mc.scheduleResourcesRefresh()
        else if (isNeedMinecraftRefreshResources)
            mc.refreshResources()
        else if (isNeedMinecraftLoadRenderers)
            mc.renderGlobal.loadRenderers()

        if (isNeedRefreshChat)
            mc.ingameGUI.chatGUI.refreshChat()

        if (isNeedMinecraftReloadSkinSetting)
            OptionManager.sendSettingsToServer()
    }

    fun reset() {
        isNeedMinecraftScheduledRefreshResources = false
        isNeedMinecraftRefreshResources = false
        isNeedMinecraftLoadRenderers = false
        isNeedRefreshChat = false
        isNeedMinecraftReloadSkinSetting = false
        isNeedShaderUninit = false
        isNeedScheduleResize = false
        isNeedScheduleResizeShadow = false
        isNeedShaderUpdateMinMag = false
    }

}