package net.minecraft.client.option

import net.bloom.bloomclient.value.Value
import net.bloom.bloomclient.value.values.*
import net.minecraft.client.MinecraftInstance
import net.minecraft.client.gui.options.value.*
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.client.option.options.devices.MouseOption
import net.minecraft.client.option.options.devices.SoundOption
import net.minecraft.client.option.options.general.*
import net.minecraft.client.option.options.videosettings.*
import net.minecraft.network.play.client.C15PacketClientSettings

object OptionManager: MinecraftInstance() {

    val generalCategories = arrayOf(
        GeneralOption,
        WorldOption,
        ChatOption,
        TitlesOption,
        TablistOption,
        SkinOption,
        DebuggingOption,
        OtherOption
    )

    val videoSettingsCategories = arrayOf(
        PerformanceOption,
        QualityOption,
        TexturesOption,
        RenderOption,
        ParticlesOption
    )

    val devicesCategories = arrayOf(
        SoundOption,
        MouseOption,
        KeyBinding,
    )

    val configCategories = generalCategories + videoSettingsCategories + devicesCategories

    @JvmStatic fun initValues() {
        configCategories.forEach { it.initOptionValues() }
    }

    fun applyValue(): Boolean {
        var reloadOnThread = false
        val values = this.values

        if (values.all { it.value == it.temporaryValue })
            return false

        values.forEach { it.applyValue() }

        if (values.any { it.applySettingOnThread })
            reloadOnThread = true

        return reloadOnThread
    }

    @JvmStatic
    fun sendSettingsToServer() {
        if (mc.thePlayer != null) {
            mc.thePlayer.sendQueue.addToSendQueue(
                C15PacketClientSettings(
                    OtherOption.language,
                    GeneralOption.renderDistance,
                    ChatOption.chatVisibilityObject.currentValueIndex,
                    ChatOption.isChatColors,
                    SkinOption.partMask
                )
            )
        }
    }

    fun getOptionComponent(value: Value<*>) = when (value) {
        is IntegerValue -> OptionIntegerValueComponent(value)
        is FloatValue -> OptionFloatValueComponent(value)
        is BoolValue -> OptionBoolValueComponent(value)
        is ListValue -> OptionListValueComponent(value)
        is KeyValue -> OptionKeyValueComponent(value)
        is GroupValue -> OptionGroupValueComponent(value)
        else -> null
    }

    val values: List<Value<*>>
        get() = configCategories.flatMap { it.values }

}