package net.minecraft.client.option

import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.value.values.*
import net.minecraft.client.gui.options.value.*

open class MinecraftOption(val name: String): Configurable() {

    val components = mutableListOf<AbstractOptionValueComponent<*>>()

    fun initOptionValues() {
        components.addAll(values.mapNotNull { OptionManager.getOptionComponent(it) })
    }

    fun boolOption(
        name: String,
        value: Boolean,
        description: String = "No description available.",
        applySettingOnThread: Boolean = false,
        applyFunction: () -> Unit = {}
    ) = super.bool(name, value, description, applySettingOnThread) { true }.onPostChange { _, _ -> applyFunction() }

    fun intOption(
        name: String,
        value: Int,
        minRange: Int,
        maxRange: Int,
        suffix: String = "",
        description: String = "No description available.",
        applySettingOnThread: Boolean = false,
        applyFunction: () -> Unit = {}
    ) = super.int(name, value, minRange, maxRange, suffix, description, applySettingOnThread) { true }.onPostChange { _, _ -> applyFunction() }

    fun listOption(
        name: String,
        value: String,
        values: Array<String>,
        description: String = "No description available.",
        applySettingOnThread: Boolean = false,
        applyFunction: () -> Unit = {}
    ) = super.list(name, value, values, description, applySettingOnThread) { true }.onPostChange { _, _ -> applyFunction() }

    fun floatOption(
        name: String,
        value: Float,
        minRange: Float,
        maxRange: Float,
        suffix: String = "",
        description: String = "No description available.",
        applySettingOnThread: Boolean = false,
        applyFunction: () -> Unit = {}
    ) = super.float(name, value, minRange, maxRange, suffix, description, applySettingOnThread) { true }.onPostChange { _, _ -> applyFunction() }
}