package net.minecraft.client.language

import net.minecraft.client.MinecraftInstance
import net.minecraft.util.ResourceLocation

data class Language(val languageCode: String, val region: String, val name: String, val bidirectionalIn: Boolean): MinecraftInstance() {

    private val translateMap = hashMapOf<String, String>()
    private val resourceLocation = ResourceLocation("lang/translation/${languageCode}_$region.lang")

    init {
        loadData()
    }

    private fun loadData() {
        val data = mc.mcDefaultResourcePack.getInputStream(resourceLocation).bufferedReader().use { it.readText() }
        println(data)
    }

    override fun toString() = String.format("%s (%s)", name, region)
}