package net.minecraft.client.input

import net.bloom.bloomclient.BloomClient
import net.bloom.bloomclient.event.KeyEvent
import net.minecraft.client.GameStorage
import net.minecraft.client.option.options.general.ChatOption
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.client.gui.options.GuiOptions
import net.minecraft.client.MinecraftInstance
import net.minecraft.client.gui.GuiChat
import net.minecraft.client.gui.GuiScreen
import net.minecraft.client.gui.inventory.GuiContainerCreative
import net.minecraft.client.gui.inventory.GuiInventory
import net.minecraft.client.gui.inventory.GuiScreenHorseInventory
import net.minecraft.client.input.DebugKeyHandler.handleDebugKeys
import net.minecraft.client.option.options.general.TablistOption
import net.minecraft.network.play.client.C16PacketClientStatus
import net.minecraft.network.play.client.C1APacketSwapHand
import net.minecraft.util.ScreenShotHelper
import org.lwjgl.input.Keyboard

/**
 * Rewrite keyboard handler system
 * @author KotlinizedMCP
 */

object KeyboardHandler: MinecraftInstance() {

	private fun handleParticularKeypresses() {
		mc.thePlayer ?: return
		val currentScreen = mc.currentScreen

        val keyEvent = if (Keyboard.getEventKey() == 0) Keyboard.getEventCharacter().code else Keyboard.getEventKey()

        if (keyEvent == 0 || Keyboard.isRepeatEvent() || !Keyboard.getEventKeyState())
        	return

        if (currentScreen != null && !currentScreen.allowUserInput)
        	return

        BloomClient.eventManager.call(KeyEvent(keyEvent))

        when (keyEvent) {
            KeyBinding.keyBindPlayerList.keyCode -> if (TablistOption.isToggleTab) {
                TablistOption.toggleTabState = !TablistOption.toggleTabState
            }

            KeyBinding.keyBindSwapOffHand.keyCode -> {
                mc.netHandler.addToSendQueue(C1APacketSwapHand())
            }

            KeyBinding.keyBindDrop.keyCode -> if (!mc.thePlayer.isSpectator) {
            	mc.thePlayer.dropOneItem(GuiScreen.isCtrlKeyDown())
            }

            KeyBinding.keyBindInventory.keyCode -> {
            	if (mc.playerController.isRidingHorse) {
	                if (currentScreen !is GuiScreenHorseInventory)
                        mc.thePlayer.sendHorseInventory()
	            } else if (currentScreen !is GuiInventory && currentScreen !is GuiContainerCreative) {
                    mc.netHandler.addToSendQueue(C16PacketClientStatus(C16PacketClientStatus.EnumState.OPEN_INVENTORY_ACHIEVEMENT))
                    mc.displayGuiScreen(GuiInventory(mc.thePlayer))
                }
            }

            KeyBinding.keyBindChat.keyCode -> {
            	if (currentScreen == null && !ChatOption.chatVisibilityObject.equals("options.chat.visibility.hidden"))
        			mc.displayGuiScreen(GuiChat())
            }

            KeyBinding.keyBindCommand.keyCode -> {
                if (currentScreen == null && !ChatOption.chatVisibilityObject.equals("options.chat.visibility.hidden"))
                    mc.displayGuiScreen(GuiChat("/"))
            }
        }

        handleDispatchKeypresses()
    }

    fun handleDispatchKeypresses() {
        val keyEvent = if (Keyboard.getEventKey() == 0) Keyboard.getEventCharacter() else Keyboard.getEventKey()

        if (keyEvent == 0 || Keyboard.isRepeatEvent() || !Keyboard.getEventKeyState())
            return
        
        if (mc.currentScreen !is GuiOptions) when (keyEvent) {
            KeyBinding.keyBindFullscreen.keyCode -> mc.toggleFullscreen()
            KeyBinding.keyBindScreenshot.keyCode -> {
                val screenshotMessage = ScreenShotHelper.saveScreenshot(
                    mc.mcDataDir, mc.displayWidth, mc.displayHeight, mc.framebufferMc)
                mc.ingameGUI.chatGUI.printChatMessage(screenshotMessage)
            }
        }
    }

    fun handleAllKeypresses() {
        mc.thePlayer ?: return
        val currentScreen = mc.currentScreen

        if (currentScreen != null && !currentScreen.allowUserInput)
       		return

        mc.mcProfiler.endStartSection("keyboard")

        handleHotbarSelection()

        if (mc.leftClickCounter > 0)
        	mc.leftClickCounter--

        while (Keyboard.next()) {
            handleParticularKeypresses()
            dispatchKeyPress()

			if (KeyBinding.keyBindTogglePerspective.isPressed()) {
                GameStorage.thirdPersonView++
                GameStorage.thirdPersonView %= 3
				mc.entityRenderer?.let {
					if (GameStorage.thirdPersonView == 0)
						it.loadEntityShader(mc.renderViewEntity)
					else
						it.loadEntityShader(null)
				}
			} 

            if (KeyBinding.keyBindSmoothCamera.isPressed())
            	GameStorage.smoothCamera = !GameStorage.smoothCamera
        }
    }

    private fun handleHotbarSelection() {
    	mc.thePlayer ?: return

    	for (i in 0..8) {
    		if (!KeyBinding.keyBindsHotbar[i].isPressed())
                continue
                
			if (mc.thePlayer.isSpectator)
				mc.ingameGUI.spectatorGui.onHotbarSelected(i)
			else
				mc.thePlayer.inventory.currentItem = i
    	}
    }

    private fun dispatchKeyPress() {
        val keyCode = Keyboard.getEventKey()
        val keyState = Keyboard.getEventKeyState()

        KeyBinding.setKeyBindState(keyCode, keyState)

        if (!keyState)
            return

        KeyBinding.onTick(keyCode)

        when (keyCode) {
            1 -> mc.displayInGameMenu()
            59 -> GameStorage.hideGUI = !GameStorage.hideGUI
            62 -> mc.entityRenderer?.switchUseShader()
            else -> handleDebugKeys(keyCode)
        }
    }

}