package net.minecraft.client.input

import net.minecraft.client.GameStorage
import net.minecraft.client.option.options.general.OtherOption
import net.minecraft.client.MinecraftInstance
import net.minecraft.client.gui.GuiScreen
import net.minecraft.client.option.options.general.DebuggingOption
import net.minecraft.client.option.options.general.GeneralOption
import net.optifine.Lagometer
import org.lwjgl.input.Keyboard

object DebugKeyHandler: MinecraftInstance() {
    fun handleDebugKeys(keyCode: Int) {
        if (Keyboard.isKeyDown(61)) {
            when (keyCode) {
                20, 33 -> adjustRenderDistance(GuiScreen.isShiftKeyDown())
                25 -> togglePauseOnLostFocus()
                30 -> mc.renderGlobal.loadRenderers()
                31 -> mc.refreshResources()
                32 -> clearChatMessages()
                35 -> toggleAdvancedItemTooltips()
                48 -> toggleDebugBoundingBox()
                61 -> toggleDebugInfo()
            }
        }
    }

    private fun adjustRenderDistance(isShiftKeyDown: Boolean) {
        val renderDistanceChange = if (isShiftKeyDown) -1 else 1
        GeneralOption.renderDistance += renderDistanceChange
        mc.renderGlobal.setDisplayListEntitiesDirty()
    }

    private fun togglePauseOnLostFocus() {
        DebuggingOption.pauseOnLostFocusObject.apply {
            value = !value
            syncValue()
        }
    }

    private fun clearChatMessages() = mc.ingameGUI?.chatGUI?.clearChatMessages()

    private fun toggleAdvancedItemTooltips() {
        OtherOption.isAdvancedTooltipsObject.apply {
            value = !value
            syncValue()
        }
    }

    private fun toggleDebugBoundingBox() = also {
        mc.renderManager.isDebugBoundingBox = !mc.renderManager.isDebugBoundingBox
    }

    private fun toggleDebugInfo() {
        GameStorage.showDebugInfo = !GameStorage.showDebugInfo
        GameStorage.showDebugProfilerChart = GuiScreen.isShiftKeyDown()
        Lagometer.showLagometer = GuiScreen.isAltKeyDown()
    }
}