package net.minecraft.client.gui.resourcepack

import net.bloom.bloomclient.utils.Constants
import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.extension.toBase64String
import net.bloom.bloomclient.utils.render.RenderUtils
import net.minecraft.client.gui.Gui
import net.minecraft.client.renderer.GlStateManager
import net.minecraft.client.resources.ResourcePackRepository
import java.awt.Color
import kotlin.math.abs

class FoundResourcePackEntry(val entry: ResourcePackRepository.Entry): AbstractResourcePackEntry(entry.resourcePackName) {

    // ma hoa base64
    val encodedString: String = name.toBase64String()

    override val resourcePackFormat: Int
        get() = entry.packFormat

    override val resourcePackDescription: String
        get() = entry.texturePackDescription

    override fun bindResourcePackIcon() {
        entry.bindTexturePackIcon(mc.textureManager)
    }

    override fun onHover(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float) {
        mc.textureManager.bindTexture(Constants.RESOURCE_PACKS_TEXTURE)
        RenderUtils.drawRect(x, y, x + 32, y + 32, color = Color(144, 144, 144))
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f)

        val j = (mouseX - x).toInt()
        val k = (mouseY - y).toInt()

        if (canMoveRight()) {
            if (j < 32) {
                Gui.drawModalRectWithCustomSizedTexture(x.toInt(), y.toInt(), 0.0f, 32.0f, 32, 32, 256.0f, 256.0f)
            } else {
                Gui.drawModalRectWithCustomSizedTexture(x.toInt(), y.toInt(), 0.0f, 0.0f, 32, 32, 256.0f, 256.0f)
            }
        } else {
            if (canMoveLeft()) {
                if (j < 16) {
                    Gui.drawModalRectWithCustomSizedTexture(x.toInt(), y.toInt(), 32.0f, 32.0f, 32, 32, 256.0f, 256.0f)
                } else {
                    Gui.drawModalRectWithCustomSizedTexture(x.toInt(), y.toInt(), 32.0f, 0.0f, 32, 32, 256.0f, 256.0f)
                }
            }

            if (canMoveUp()) {
                if (j in 17..31 && k < 16) {
                    Gui.drawModalRectWithCustomSizedTexture(x.toInt(), y.toInt(), 96.0f, 32.0f, 32, 32, 256.0f, 256.0f)
                } else {
                    Gui.drawModalRectWithCustomSizedTexture(x.toInt(), y.toInt(), 96.0f, 0.0f, 32, 32, 256.0f, 256.0f)
                }
            }

            if (canMoveDown()) {
                if (j in 17..31 && k > 16) {
                    Gui.drawModalRectWithCustomSizedTexture(x.toInt(), y.toInt(), 64.0f, 32.0f, 32, 32, 256.0f, 256.0f)
                } else {
                    Gui.drawModalRectWithCustomSizedTexture(x.toInt(), y.toInt(), 64.0f, 0.0f, 32, 32, 256.0f, 256.0f)
                }
            }
        }
    }

    fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Boolean {
        if (!MathUtils.isHover(mouseX, mouseY, x, y, x2, y2))
            return false

        val diffX = abs(mouseX - x)
        val diffY = abs(mouseY - y)

        if (diffX > 32)
            return false

        if (canMoveRight()) {
            mc.resourcePackRepository.availableResourcePacks.remove(this)
            mc.resourcePackRepository.selectedResourcePacks.add(0, this)
            mc.resourcePackRepository.isChanged = true
            return true
        }

        if (canMoveLeft()) {
            if (diffX < 16) {
                mc.resourcePackRepository.selectedResourcePacks.remove(this)
                mc.resourcePackRepository.availableResourcePacks.add(0, this)
                mc.resourcePackRepository.isChanged = true
                return true
            }

            if (diffX > 16 && diffY in 0f..16f && canMoveUp()) {
                val k = mc.resourcePackRepository.selectedResourcePacks.indexOf(this)
                mc.resourcePackRepository.selectedResourcePacks.remove(this)
                mc.resourcePackRepository.selectedResourcePacks.add(k - 1, this)
                mc.resourcePackRepository.isChanged = true
                return true
            }

            if (diffX > 16 && diffY in 16f..32f && canMoveDown()) {
                val i = mc.resourcePackRepository.selectedResourcePacks.indexOf(this)
                mc.resourcePackRepository.selectedResourcePacks.remove(this)
                mc.resourcePackRepository.selectedResourcePacks.add(i + 1, this)
                mc.resourcePackRepository.isChanged = true
                return true
            }
        }

        return false
    }

    private fun canMoveRight() = this in mc.resourcePackRepository.availableResourcePacks

    private fun canMoveLeft() = this in mc.resourcePackRepository.selectedResourcePacks

    private fun canMoveUp() = mc.resourcePackRepository.selectedResourcePacks.indexOf(this) > 0

    private fun canMoveDown(): Boolean {
        val idx = mc.resourcePackRepository.selectedResourcePacks.indexOf(this)
        return idx >= 0 && idx < mc.resourcePackRepository.selectedResourcePacks.size - 1
    }


}