package net.minecraft.client.gui.resourcepack

import com.google.gson.JsonParseException
import net.minecraft.client.Minecraft
import net.minecraft.client.renderer.texture.DynamicTexture
import net.minecraft.client.renderer.texture.TextureUtil
import net.minecraft.client.resources.data.PackMetadataSection
import net.minecraft.util.EnumChatFormatting
import net.minecraft.util.ResourceLocation
import java.io.IOException

object DefaultResourcePackEntry: AbstractResourcePackEntry("Default") {

    private val resourcePack = mc.resourcePackRepository.rprDefaultResourcePack
    private val resourcePackIcon: ResourceLocation

    init {
        val dynamicTexture = try {
            DynamicTexture(this.resourcePack.getPackImage())
        } catch (e: IOException) {
            TextureUtil.missingTexture
        }

        this.resourcePackIcon = mc.textureManager.getDynamicTextureLocation("texturepackicon", dynamicTexture)
    }

    override val resourcePackFormat = 1

    override val resourcePackDescription: String
        get() {
            try {
                val section: PackMetadataSection = this.resourcePack.getPackMetadata(mc.resourcePackRepository.rprMetadataSerializer, "pack")
                return section.packDescription.getFormattedText()
            } catch (e: JsonParseException) {
                Minecraft.logger.error("Couldn't load metadata info", e)
            } catch (e: IOException) {
                Minecraft.logger.error("Couldn't load metadata info", e)
            }

            return "${EnumChatFormatting.RED}Missing pack.mcmeta :("
        }

    override fun bindResourcePackIcon() {
        mc.textureManager.bindTexture(resourcePackIcon)
    }
}