package net.minecraft.client.gui.resourcepack

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.render.RenderUtils
import net.minecraft.client.MinecraftInstance
import net.minecraft.client.gui.Gui
import net.minecraft.client.renderer.GlStateManager
import java.awt.Color

abstract class AbstractResourcePackEntry(val name: String): MinecraftInstance() {
    fun drawEntry(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float) {
        if (resourcePackFormat != 1) {
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f)
            RenderUtils.drawRect(x - 1f, y - 1f, x2 - 9, y2 + 1, 0f, color = Color(119, 0, 0))
        }

        bindResourcePackIcon()
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f)
        Gui.drawModalRectWithCustomSizedTexture(x.toInt(), y.toInt(), 0.0f, 0.0f, 32, 32, 32f, 32f)

        var line1 = name
        val line2 = resourcePackDescription

        if (MathUtils.isHover(mouseX, mouseY, x, y, x2, y2))
            onHover(mouseX, mouseY, x, y, x2, y2)

        val line1StringWidth = mc.minecraftFontRendererObj.getStringWidth(line1)

        if (line1StringWidth > 157) {
            line1 = mc.minecraftFontRendererObj.trimStringToWidth(line1, 157 - mc.minecraftFontRendererObj.getStringWidth("...")) + "..."
        }

        mc.minecraftFontRendererObj.drawStringWithShadow(line1, x + 32 + 2, y + 1, 16777215)
        val formattedStringList = mc.minecraftFontRendererObj.listFormattedStringToWidth(line2, 157).take(2)

        for ((index, text) in formattedStringList.withIndex())
            mc.minecraftFontRendererObj.drawStringWithShadow(text, x + 32 + 2, y + 12 + 10 * index, 8421504)

    }

    protected open fun onHover(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float) {}

    abstract val resourcePackFormat: Int

    abstract val resourcePackDescription: String

    abstract fun bindResourcePackIcon()

}