package net.minecraft.client.gui.options.value

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.value.values.ListValue
import net.minecraft.client.resources.LanguageManager
import java.awt.Color

open class OptionListValueComponent(value: ListValue): AbstractOptionValueComponent<ListValue>(value) {
    override fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float {
        val fontYPos = y + 2 + (14 - mc.minecraftFontRendererObj.FONT_HEIGHT) / 2f
        val currentValue = LanguageManager.format(value.displayedValue)
        val stringWidth = mc.minecraftFontRendererObj.getStringWidth(currentValue)
        mc.minecraftFontRendererObj.drawString(currentValue, x2 - 8f - stringWidth, fontYPos, Color.WHITE)
        return 20f
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int): Float {
        val fontYPos = y + 2 + (14 - mc.minecraftFontRendererObj.FONT_HEIGHT) / 2f
        val currentValue = LanguageManager.format(value.displayedValue)
        val stringWidth = mc.minecraftFontRendererObj.getStringWidth(currentValue)

        if (MathUtils.isHover(mouseX, mouseY, x2 - 8f - stringWidth, fontYPos, x2 - 8f, fontYPos + mc.minecraftFontRendererObj.FONT_HEIGHT)) {
            value.nextTemporaryValue()
            return 0f
        }

        return 20f
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long): Float {
        return 20f
    }
}