package net.minecraft.client.gui.options.value

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.value.values.KeyValue
import org.lwjgl.input.Keyboard
import java.awt.Color

class OptionKeyValueComponent(value: KeyValue): AbstractOptionValueComponent<KeyValue>(value) {
    private var isBinding = false

    override fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float {
        val fontYPos = y + 2 + (14 - mc.minecraftFontRendererObj.FONT_HEIGHT) / 2f
        val currentValue = if (!isBinding) value.displayedValue else "Listening..."
        val stringWidth = mc.minecraftFontRendererObj.getStringWidth(currentValue)
        mc.minecraftFontRendererObj.drawString(currentValue, x2 - 8f - stringWidth, fontYPos, Color.WHITE)
        return 20f
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int): Float {
        val fontYPos = y + 2 + (14 - mc.minecraftFontRendererObj.FONT_HEIGHT) / 2f

        if (isBinding) {
            value.temporaryValue = mouseButton - 100
            isBinding = false
            return 0f
        }

        val currentValue = value.displayedValue
        val stringWidth = mc.minecraftFontRendererObj.getStringWidth(currentValue)

        if (MathUtils.isHover(mouseX, mouseY, x2 - 8f - stringWidth, fontYPos, x2 - 8f, fontYPos + mc.minecraftFontRendererObj.FONT_HEIGHT)) {
            isBinding = true
            return 0f
        }

        return 20f
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long): Float {
        return 20f
    }

    override fun onKeyTyped(typedChar: Char, keyCode: Int): Boolean {
        if (isBinding) {
            value.temporaryValue = if (keyCode == Keyboard.KEY_ESCAPE) Keyboard.KEY_NONE else keyCode
            isBinding = false
            return true
        }

        return false
    }
}