package net.minecraft.client.gui.options.value

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.render.RenderUtils
import net.bloom.bloomclient.value.values.IntegerValue
import java.awt.Color
import kotlin.math.round

open class OptionIntegerValueComponent(value: IntegerValue): AbstractOptionValueComponent<IntegerValue>(value) {
    override fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float {
        val fontYPos = y + 2 + (14 - mc.minecraftFontRendererObj.FONT_HEIGHT) / 2f
        val minRange = value.minRange
        val valueWidth = (value.temporaryValue - minRange) * 100 / value.deltaRange

        RenderUtils.drawRect(x2 - 108f, y + 8f, x2 - 8f, y + 10f, color = Color.WHITE)
        RenderUtils.drawRect(x2 - 109f + valueWidth, y + 5f, x2 - 107f + valueWidth, y + 13f, color = Color.WHITE)

        val valueText = value.displayedValue
        val stringWidth = mc.minecraftFontRendererObj.getStringWidth(valueText)
        mc.minecraftFontRendererObj.drawString(valueText, x2 - 115f - stringWidth, fontYPos, Color.WHITE)
        return 20f
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long): Float {
        val minRange = value.minRange
        val maxRange = value.maxRange

        if (MathUtils.isHover(mouseX, mouseY, x2 - 111f, y + 5f, x2 - 5f, y + 13f)) {
            val newValue = minRange + (mouseX - x2 + 108f) * value.deltaRange / 100
            value.temporaryValue = round(newValue).toInt().coerceIn(minRange, maxRange)
            return 0f
        }

        return 20f
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int): Float {
        return 20f
    }
}