package net.minecraft.client.gui.options.value

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.render.RenderUtils
import net.bloom.bloomclient.value.values.GroupValue
import net.minecraft.client.option.OptionManager
import java.awt.Color

open class OptionGroupValueComponent(value: GroupValue, var marginLeft: Float = 8f): AbstractOptionValueComponent<GroupValue>(value) {
    open val components: List<AbstractOptionValueComponent<*>> = value.value.mapNotNull {
        OptionManager.getOptionComponent(it).also { component ->
            if (component is OptionGroupValueComponent)
                component.marginLeft = this.marginLeft + 8f
        }
    }.toList()

    override fun drawValueName(x: Float, y: Float) {
        val stringState = if (value.isListOpen) "▼" else "▶"
        val fontYPos = y + 2 + (14 - mc.minecraftFontRendererObj.FONT_HEIGHT) / 2f
        mc.minecraftFontRendererObj.drawString("$stringState $displayedName", x, fontYPos, Color.WHITE)
    }

    override fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float {
        var valueY = 20f

        if (value.isListOpen)
            for (component in components) {
                component.drawValueName(x + marginLeft, y + valueY)
                valueY += component.drawValue(mouseX, mouseY, x + marginLeft, y + valueY, x2, y2)
            }

        return valueY
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long): Float {
        var valueY = 20f

        if (value.isListOpen)
            for (component in components) {
                val incHeight = component.mouseClickMove(mouseX, mouseY, x + marginLeft, y + valueY, x2, y2, clickedMouseButton, timeSinceLastClick)

                if (incHeight == 0f)
                    return 0f

                valueY += incHeight
            }

        return valueY
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int): Float {
        val stringState = if (value.isListOpen) "▼" else "▶"
        val stringWidth = mc.minecraftFontRendererObj.getStringWidth("$stringState ${value.name}")
        val fontYPos = y + 2 + (14 - mc.minecraftFontRendererObj.FONT_HEIGHT) / 2f

        if (MathUtils.isHover(mouseX, mouseY, x, fontYPos, x + stringWidth, fontYPos + mc.minecraftFontRendererObj.FONT_HEIGHT)) {
            value.isListOpen = !value.isListOpen
            return 0f
        }

        var valueY = 20f

        if (value.isListOpen)
            for (component in components) {
                val incHeight = component.mouseClicked(mouseX, mouseY, x + marginLeft, y + valueY, x2, y2, mouseButton)

                if (incHeight == 0f)
                    return 0f

                valueY += incHeight
            }

        return valueY
    }
}