package net.minecraft.client.gui.options.value

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.render.RenderUtils
import net.bloom.bloomclient.value.values.BoolValue
import net.minecraft.client.gui.options.value.AbstractOptionValueComponent
import java.awt.Color

open class OptionBoolValueComponent(value: BoolValue): AbstractOptionValueComponent<BoolValue>(value) {

    override fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float {
        RenderUtils.drawRect(x2 - 22f, y + 1f, x2 - 8f, y + 15f, color = Color.WHITE, border = true, borderWidth = 1f)

        if (value.temporaryValue)
            RenderUtils.drawRect(x2 - 20f, y + 3f, x2 - 10f, y + 13f, color = Color.WHITE)

        return 20f
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int): Float {
        if (MathUtils.isHover(mouseX, mouseY, x2 - 22f, y + 1f, x2 - 8f, y + 15f)) {
            value.temporaryValue = !value.temporaryValue
            return 0f
        }

        return 20f
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long): Float {
        return 20f
    }

}