package net.minecraft.client.gui.options.value

import net.bloom.bloomclient.value.Value
import net.minecraft.client.MinecraftInstance
import net.minecraft.client.resources.LanguageManager
import java.awt.Color

abstract class AbstractOptionValueComponent<T: Value<*>>(val value: T): MinecraftInstance() {
    open val displayedName: String
        get() = LanguageManager.format(value.name)

    open fun drawValueName(x: Float, y: Float) {
        val fontYPos = y + 2 + (14 - mc.minecraftFontRendererObj.FONT_HEIGHT) / 2f
        val italic = if (value.value != value.temporaryValue) "§o* " else ""
        mc.minecraftFontRendererObj.drawString("$italic$displayedName", x, fontYPos, Color.WHITE)
    }

    abstract fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float

    open fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long) = 0f

    open fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int) = 0f

    open fun onKeyTyped(typedChar: Char, keyCode: Int): Boolean = false

}