package net.minecraft.client.gui.options.page

import net.bloom.bloomclient.file.FileManager
import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.render.RenderUtils
import net.bloom.bloomclient.utils.render.ScrollUtils
import net.bloom.bloomclient.utils.struct.TickTimer
import net.minecraft.client.gui.ScaledResolution
import net.minecraft.client.option.options.ActionQueue
import net.minecraft.client.option.options.ShadersOption
import net.optifine.shaders.ShaderManager
import net.optifine.shaders.Shaders
import net.optifine.shaders.file.AbstractShaderPack
import net.optifine.shaders.file.NoneShaderPack
import java.awt.Color
import kotlin.math.max

object ShaderPage: OptionPage() {
    private val shaderGlobalSettingScrollUtils = ScrollUtils()
    private val shaderListScrollUtils = ScrollUtils()
    private val tickTimer = TickTimer()
    private var currentShaderPack: AbstractShaderPack = NoneShaderPack
    var temporaryShaderPack: AbstractShaderPack = NoneShaderPack

    override fun drawScreen(mouseX: Int, mouseY: Int, partialTicks: Float) {
        tickTimer.waitTicks(60) { ShaderManager.watchdogFindShaderpacks() }

        val sc = ScaledResolution(mc)
        val fontHeight = mc.minecraftFontRendererObj.FONT_HEIGHT

        val endXFirstHalfPanel = 15f + (sc.scaledWidth - 30f) / 2 - 8f
        val endYFirstHalfPanel = 45f + (sc.scaledHeight - 90f) / 2 - 4f

        // Draw shader settings
        RenderUtils.drawRect(15f, 45f, endXFirstHalfPanel, endYFirstHalfPanel, color = Color(0, 0, 0, 130))

        RenderUtils.renderScissorBox(15f, 45f, endXFirstHalfPanel, endYFirstHalfPanel) {
            var totalValueY = 0

            for (component in ShadersOption.components) {
                val yPos = 50f - shaderGlobalSettingScrollUtils.scroll + totalValueY

                component.drawValueName(20f, yPos)
                component.drawValue(mouseX, mouseY, 15f, yPos, endXFirstHalfPanel, endYFirstHalfPanel)

                totalValueY += 20
            }

            val valueMaxScroll = max(0f,totalValueY - endYFirstHalfPanel + 55f)

            if (MathUtils.isHover(mouseX, mouseY, 15f, 45f, endXFirstHalfPanel, endYFirstHalfPanel)) {
                shaderGlobalSettingScrollUtils.max = valueMaxScroll
                shaderGlobalSettingScrollUtils.update()
            }
        }

        RenderUtils.drawRect(15f, endYFirstHalfPanel + 8f, endXFirstHalfPanel, sc.scaledHeight - 45f, color = Color(0, 0, 0, 130))
        mc.minecraftFontRendererObj.drawString("Shader list", 25f, endYFirstHalfPanel + 15f, Color.WHITE)

        RenderUtils.renderScissorBox(15f, endYFirstHalfPanel + 18f + fontHeight, endXFirstHalfPanel, sc.scaledHeight - 45f) {
            var yPos = endYFirstHalfPanel + 25f + fontHeight - shaderListScrollUtils.scroll

            for (shaderPack in ShaderManager.shaderPacks) {
                val color = if (shaderPack == temporaryShaderPack) Color(252, 186, 3) else Color.WHITE
                mc.minecraftFontRendererObj.drawString(shaderPack.name, 25f, yPos, color)
                yPos += fontHeight + 8f
            }

            val valueMaxScroll = max(0f, yPos - (sc.scaledHeight - 45f - endYFirstHalfPanel - 8f - 10f))

            if (MathUtils.isHover(mouseX, mouseY, 15f, endYFirstHalfPanel + 8f, endXFirstHalfPanel, sc.scaledHeight - 45f)) {
                shaderListScrollUtils.max = valueMaxScroll
                shaderListScrollUtils.update()
            }
        }

        RenderUtils.drawRect(endXFirstHalfPanel + 16f, 45f, sc.scaledWidth - 15f, sc.scaledHeight - 45f, color = Color(0, 0, 0, 130))

        RenderUtils.renderScissorBox(endXFirstHalfPanel + 16f, 45f, sc.scaledWidth - 15f, sc.scaledHeight - 45f) {
            var totalValueY = 0f

            for (component in currentShaderPack.options.components) {
                val yPos = 50f + totalValueY - currentShaderPack.options.scrollUtils.scroll
                component.drawValueName(endXFirstHalfPanel + 16f + 5f, yPos)
                totalValueY += component.drawValue(mouseX, mouseY, endXFirstHalfPanel + 16f + 5f, yPos, sc.scaledWidth - 15f, sc.scaledHeight - 45f)
            }

            val valueMaxScroll = max(0f, totalValueY - sc.scaledHeight + 100f)

            if (MathUtils.isHover(mouseX, mouseY, endXFirstHalfPanel + 16f, 45f, sc.scaledWidth - 15f, sc.scaledHeight - 45f)) {
                currentShaderPack.options.scrollUtils.max = valueMaxScroll
                currentShaderPack.options.scrollUtils.update()
            }
        }
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, mouseButton: Int): Boolean {
        val sc = ScaledResolution(mc)
        val fontHeight = mc.minecraftFontRendererObj.FONT_HEIGHT
        var totalValueY = 0f

        val endXFirstHalfPanel = 15f + (sc.scaledWidth - 30f) / 2 - 8f
        val endYFirstHalfPanel = 45f + (sc.scaledHeight - 90f) / 2 - 4f

        for (component in ShadersOption.components) {
            val yPos = 50f - shaderGlobalSettingScrollUtils.scroll + totalValueY
            val incHeight = component.mouseClicked(mouseX, mouseY, 15f, yPos, endXFirstHalfPanel, endYFirstHalfPanel, mouseButton)

            if (incHeight == 0f)
                return true

            totalValueY += incHeight
        }

        var yPos = endYFirstHalfPanel + 25f + fontHeight - shaderListScrollUtils.scroll

        for (shaderPack in ShaderManager.shaderPacks) {
            val stringWidth = mc.minecraftFontRendererObj.getStringWidth(shaderPack.name)
            if (MathUtils.isHover(mouseX, mouseY, 25f, yPos, 25f + stringWidth, yPos + fontHeight)) {
                if (mouseButton == 0)
                    temporaryShaderPack = shaderPack
                else if (mouseButton == 1)
                    currentShaderPack = shaderPack

                return true
            }
            yPos += fontHeight + 8f
        }

        var shaderPackTotalValueY = 0f

        for (component in currentShaderPack.options.components) {
            val shaderPackYPos = 50f + shaderPackTotalValueY - currentShaderPack.options.scrollUtils.scroll
            val incHeight = component.mouseClicked(mouseX, mouseY, endXFirstHalfPanel + 16f + 5f, shaderPackYPos, sc.scaledWidth - 15f, sc.scaledHeight - 45f, mouseButton)

            if (incHeight == 0f)
                return true

            shaderPackTotalValueY += incHeight
        }

        return false
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, clickedMouseButton: Int, timeSinceLastClick: Long) {
        val sc = ScaledResolution(mc)
        var totalValueY = 0

        val endXFirstHalfPanel = 15f + (sc.scaledWidth - 30f) / 2 - 8f
        val endYFirstHalfPanel = 45f + (sc.scaledHeight - 90f) / 2 - 4f

        for (component in ShadersOption.components) {
            val yPos = 50f - shaderGlobalSettingScrollUtils.scroll + totalValueY
            component.mouseClickMove(mouseX, mouseY, 15f, yPos, endXFirstHalfPanel, endYFirstHalfPanel, clickedMouseButton, timeSinceLastClick)
            totalValueY += 20
        }

        var shaderPackTotalValueY = 0f

        for (component in currentShaderPack.options.components) {
            val shaderPackYPos = 50f + shaderPackTotalValueY - currentShaderPack.options.scrollUtils.scroll
            val incHeight = component.mouseClickMove(mouseX, mouseY, endXFirstHalfPanel + 16f + 5f, shaderPackYPos, sc.scaledWidth - 15f, sc.scaledHeight - 45f, clickedMouseButton, timeSinceLastClick)

            if (incHeight == 0f)
                return

            shaderPackTotalValueY += incHeight
        }
    }

    @JvmStatic
    fun applyValue(force: Boolean = false): Boolean {
        var uninit = false

        if (temporaryShaderPack != ShaderManager.shaderPack) {
            Shaders.loadShaderPack()
            uninit = true
        }

        ShaderManager.shaderPacks.minus(ShaderManager.builtInPacks).forEach {
            val isChanged = it.applyValues()

            if (isChanged && it == ShaderManager.shaderPack)
                uninit = true

            FileManager.saveConfig(it.config)
        }

        if (uninit) {
            if (force)
                Shaders.uninit()
            else
                ActionQueue.isNeedShaderUninit = true
        }

        return false
    }


}