package net.minecraft.client.gui.options.page

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.render.RenderUtils
import net.bloom.bloomclient.utils.render.ScrollUtils
import net.minecraft.client.gui.ScaledResolution
import net.minecraft.client.option.*
import org.lwjgl.input.Mouse
import java.awt.Color
import kotlin.math.max

class SettingPage(private val optionCategories: Array<MinecraftOption>): OptionPage() {
    private val scrollUtils = ScrollUtils()
    private var currentCategory = optionCategories.first()
        set(value) {
            field = value
            scrollUtils.reset()
        }

    override fun drawScreen(mouseX: Int, mouseY: Int, partialTicks: Float) {
        val sc = ScaledResolution(mc)

        // draw category
        RenderUtils.drawRect(40f, 45f, 140f, sc.scaledHeight - 45f, 0f, Color(0, 0, 0, 130))
        var yPosModule = 55f

        val fontHeight = mc.minecraftFontRendererObj.FONT_HEIGHT
        RenderUtils.renderScissorBox(40f, 45f, 140f, sc.scaledHeight - 45f) {
            for (category in optionCategories) {
                if (currentCategory == category)
                    RenderUtils.drawRect(40f, yPosModule - 3, 42f, yPosModule + fontHeight + 3, 0f, Color.CYAN)

                mc.minecraftFontRendererObj.drawString(category.name, 50f, yPosModule, Color.WHITE)
                yPosModule += 18
            }
        }

        RenderUtils.drawRect(160f, 45f, sc.scaledWidth - 30f, sc.scaledHeight - 45f, 0f, Color(0, 0, 0, 130))

        RenderUtils.renderScissorBox(160f, 45f, sc.scaledWidth - 30f, sc.scaledHeight - 60f) {
            var totalValueY = 0f

            for (component in currentCategory.components) {
                val yPos = 55f - scrollUtils.scroll + totalValueY
                component.drawValueName(175f, yPos)
                totalValueY += component.drawValue(mouseX, mouseY, 175f, yPos, sc.scaledWidth - 40f, sc.scaledHeight - 60f)
            }

            val valueMaxScroll = max(0f, totalValueY - (sc.scaledHeight - 60f - 60f))
            if (MathUtils.isHover(mouseX, mouseY, 160f, 45f, sc.scaledWidth - 30f, sc.scaledHeight - 60f)) {
                scrollUtils.max = valueMaxScroll
                scrollUtils.update()
            }
        }
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, mouseButton: Int): Boolean {
        val sc = ScaledResolution(mc)
        var yPosModule = 55f
        val fontHeight = mc.minecraftFontRendererObj.FONT_HEIGHT.toFloat()

        for (category in optionCategories) {
            if (MathUtils.isHover(mouseX, mouseY, 40f, yPosModule - 3, 140f, yPosModule + fontHeight + 3)) {
                currentCategory = category
                return true
            }

            yPosModule += 18
        }

        var totalValueY = 0f

        for (component in currentCategory.components) {
            val yPos = 55f - scrollUtils.scroll + totalValueY
            val incHeight = component.mouseClicked(mouseX, mouseY, 175f, yPos, sc.scaledWidth - 40f, sc.scaledHeight - 60f, mouseButton)
            if (incHeight == 0f)
                return true

            totalValueY += incHeight
        }

        return false
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, clickedMouseButton: Int, timeSinceLastClick: Long) {
        val sc = ScaledResolution(mc)
        var totalValueY = 0f

        for (component in currentCategory.components) {
            val yPos = 55f - scrollUtils.scroll + totalValueY
            val incHeight = component.mouseClickMove(mouseX, mouseY, 175f, yPos, sc.scaledWidth - 40f, sc.scaledHeight - 60f, clickedMouseButton, timeSinceLastClick)

            if (incHeight == 0f)
                return

            totalValueY += incHeight
        }
    }

    override fun keyTyped(typedChar: Char, keyCode: Int): Boolean {
        return currentCategory.components.any { it.onKeyTyped(typedChar, keyCode) }
    }
}