package net.minecraft.client.gui.options.page

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.render.RenderUtils
import net.bloom.bloomclient.utils.render.ScrollUtils
import net.bloom.bloomclient.utils.struct.TickTimer
import net.minecraft.client.gui.ScaledResolution
import net.minecraft.client.option.options.ActionQueue
import org.lwjgl.input.Mouse
import java.awt.Color
import kotlin.math.max

object ResourcePackPage: OptionPage() {
    private val tickTimer = TickTimer()

    private val availableScrollUtils = ScrollUtils()
    private val selectedScrollUtils = ScrollUtils()

    override fun drawScreen(mouseX: Int, mouseY: Int, partialTicks: Float) {
        tickTimer.waitTicks(20) {
            mc.resourcePackRepository.updateRepositoryEntries()
        }

        val sc = ScaledResolution(mc)

        val availableResourcePackEndX = sc.scaledWidth / 2 - 8f
        val selectedResourcePackStartX = sc.scaledWidth / 2 + 8f
        val endY = sc.scaledHeight - 45f

        // Available resource pack
        RenderUtils.drawRect(15f, 45f, availableResourcePackEndX, endY, 0f, Color(0, 0, 0, 130))
        val availableResourcePackStringWidth = mc.minecraftFontRendererObj.getStringWidth("Available resource packs")
        val availableResourcePackStringX = 15f + (availableResourcePackEndX - 15f - availableResourcePackStringWidth) / 2
        mc.minecraftFontRendererObj.drawString("Available resource packs", availableResourcePackStringX, 55f, Color.WHITE)

        RenderUtils.renderScissorBox(15f, 65f, availableResourcePackEndX, endY) {
            var valueY = 75f
            // draw default resource entry
            for (resourcePack in mc.resourcePackRepository.availableResourcePacks) {
                val yPos = valueY - availableScrollUtils.scroll
                resourcePack.drawEntry(mouseX, mouseY, 20f, yPos, availableResourcePackEndX - 5f, yPos + 32f)
                valueY += 40f
            }

            val valueMaxScroll = max(0f, valueY - (endY - 15f))

            if (MathUtils.isHover(mouseX, mouseY, 15f, 65f, availableResourcePackEndX, endY)) {
                availableScrollUtils.max = valueMaxScroll
                availableScrollUtils.update()
            }
        }

        // Selected resource pack
        RenderUtils.drawRect(selectedResourcePackStartX, 45f, sc.scaledWidth - 15f, endY, 0f, Color(0, 0, 0, 130))
        val selectedResourcePackStringWidth = mc.minecraftFontRendererObj.getStringWidth("Selected resource packs")
        val selectedResourcePackStringX = selectedResourcePackStartX + (sc.scaledWidth - 15f - selectedResourcePackStartX - selectedResourcePackStringWidth) / 2
        mc.minecraftFontRendererObj.drawString("Selected resource packs", selectedResourcePackStringX, 55f, Color.WHITE)

        RenderUtils.renderScissorBox(selectedResourcePackStartX, 65f, sc.scaledWidth - 15f, endY) {
            var valueY = 75f
            // draw default resource entry
            for (resourcePack in mc.resourcePackRepository.selectedResourcePacks) {
                val yPos = valueY - selectedScrollUtils.scroll
                resourcePack.drawEntry(mouseX, mouseY, selectedResourcePackStartX + 5f, yPos, sc.scaledWidth - 20f, yPos + 32f)
                valueY += 40f
            }

            val valueMaxScroll = max(0f, valueY - (endY - 15f))

            if (MathUtils.isHover(mouseX, mouseY, selectedResourcePackStartX, 65f, sc.scaledWidth - 15f, endY)) {
                selectedScrollUtils.max = valueMaxScroll
                selectedScrollUtils.update()
            }
        }
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, mouseButton: Int): Boolean {
        val sc = ScaledResolution(mc)

        val availableResourcePackEndX = sc.scaledWidth / 2 - 8f
        val selectedResourcePackStartX = sc.scaledWidth / 2 + 8f

        var valueY = 75f
        for (resourcePack in mc.resourcePackRepository.availableResourcePacks) {
            val yPos = valueY - availableScrollUtils.scroll
            if (resourcePack.mouseClicked(mouseX, mouseY, 20f, yPos, availableResourcePackEndX - 5f, yPos + 32f))
                return true

            valueY += 40f
        }

        var selectedValueY = 75f
        for (resourcePack in mc.resourcePackRepository.selectedResourcePacks) {
            val yPos = selectedValueY - selectedScrollUtils.scroll
            if (resourcePack.mouseClicked(mouseX, mouseY, selectedResourcePackStartX + 5f, yPos, sc.scaledWidth - 20f, yPos + 32f))
                 return true

            selectedValueY += 40f
        }

        return super.mouseClicked(mouseX, mouseY, mouseButton)
    }

    fun applyResourcePacks(): Boolean {
        if (mc.resourcePackRepository.isChanged) {
            val list = mc.resourcePackRepository.selectedResourcePacks.map { it.entry }.reversed()
            mc.resourcePackRepository.setRepositories(list)
            ActionQueue.isNeedMinecraftRefreshResources = true
            mc.resourcePackRepository.isChanged = false
        }

        return false
    }

}