package net.minecraft.client.gui.options.page

import net.minecraft.client.MinecraftInstance

abstract class OptionPage: MinecraftInstance() {

    abstract fun drawScreen(mouseX: Int, mouseY: Int, partialTicks: Float)

    open fun mouseClicked(mouseX: Int, mouseY: Int, mouseButton: Int) = false

    open fun keyTyped(typedChar: Char, keyCode: Int) = false

    open fun mouseReleased(mouseX: Int, mouseY: Int, state: Int) = false

    open fun mouseClickMove(mouseX: Int, mouseY: Int, clickedMouseButton: Int, timeSinceLastClick: Long) {}

}