package net.minecraft.client.gui.options

import net.bloom.bloomclient.utils.MathUtils.isHover
import net.bloom.bloomclient.utils.render.RenderUtils
import net.minecraft.client.Minecraft
import net.minecraft.client.gui.GuiButton
import java.awt.Color

open class GuiNewButton : GuiButton {
    constructor(buttonId: Int, x: Int, y: Int, buttonText: String?) : super(buttonId, x, y, buttonText)
    constructor(buttonId: Int, x: Int, y: Int, widthIn: Int, heightIn: Int, buttonText: String?) : super(buttonId, x, y, widthIn, heightIn, buttonText)

    override fun drawButton(mc: Minecraft, mouseX: Int, mouseY: Int) {
        val minecraftFontRenderer = mc.minecraftFontRendererObj
        val color = if (isHover(mouseX, mouseY, xPosition, yPosition, xPosition + width, yPosition + height))
            Color(0, 0, 0, 220)
        else
            Color(0, 0, 0, 130)

        RenderUtils.drawRect(xPosition, yPosition, xPosition + width, yPosition + height, color)
        val textColor = if (isButtonDisabled) Color(255, 255, 255, 30) else Color.WHITE
        minecraftFontRenderer.drawString(
            displayString,
            (xPosition + (width - minecraftFontRenderer.getStringWidth(displayString)) / 2f).toInt(),
            (yPosition + (height - minecraftFontRenderer.FONT_HEIGHT) / 2f).toInt(),
            textColor.rgb
        )

        hovered = mouseX >= xPosition && mouseY >= yPosition && mouseX < xPosition + width && mouseY < yPosition + height
    }

    open val isButtonDisabled: Boolean
        get() = false
}
