package net.bloom.bloomclient.value.values.shaders

import net.bloom.bloomclient.utils.Constants
import net.bloom.bloomclient.value.values.IntegerValue

class ShaderSliderValue(
    name: String,
    description: String,
    value: String,
    val values: Array<String>,
    val path: String,
    private val initType: VariableType,
    val type: String = ""
): IntegerValue(name, description, values.indexOf(value), 0, values.size, "", { true }, null, false), IShaderOption {

    override val paths = mutableSetOf(path)

    override val displayedValue: String
        get() = realValue

    val realValue: String
        get() = values.getOrElse(value) { values.first() }

    override fun getSourceLine() = when (initType) {
        VariableType.DEFINE -> "#define $name $realValue // Shader option $realValue"
        VariableType.CONST -> "const $type $name = $realValue; // Shader option $realValue"
    }
    override fun matchesLine(line: String): Boolean {
        val (idx, pattern) = when (initType) {
            VariableType.DEFINE -> 1 to Constants.PATTERN_VARIABLE
            VariableType.CONST -> 2 to Constants.PATTERN_CONST_BOOL
        }

        val matcher = pattern.matcher(line)
        return matcher.matches() && matcher.group(idx).matches(name.toRegex())
    }

    override fun checkUsed() = false

    override fun isUsedInLine(line: String) = false

}