package net.bloom.bloomclient.value.values.shaders

import net.bloom.bloomclient.value.values.ListValue
import net.optifine.shaders.shaderoption.ShaderProfile

class ShaderProfileValue(
    name: String,
    description: String,
    profile: ShaderProfile,
    val profiles: MutableSet<ShaderProfile>
): ListValue(name, description, profile.name, arrayOf(profile.name), { true }, null, false) {

    init {
        profiles.add(CustomProfile)
        values = profiles.map { it.name }.toTypedArray()
    }

    fun getProfile() = profiles.find { it.name == value } ?: CustomProfile

}

object CustomProfile: ShaderProfile("Custom")