package net.bloom.bloomclient.value.values.shaders

import net.bloom.bloomclient.utils.Constants
import net.bloom.bloomclient.value.values.ListValue

class ShaderListValue(
    name: String,
    description: String,
    value: String,
    values: Array<String>,
    val path: String,
    private val initType: VariableType,
    val type: String = ""
): ListValue(name, description, value, values, { true }, null, false), IShaderOption {
    override val paths = mutableSetOf(path)

    override fun getSourceLine() = when (initType) {
        VariableType.DEFINE -> "#define $name $value // Shader option $value"
        VariableType.CONST -> "const $type $name = $value; // Shader option $value"
    }

    override fun matchesLine(line: String): Boolean {
        val (idx, pattern) = when (initType) {
            VariableType.DEFINE -> 1 to Constants.PATTERN_VARIABLE
            VariableType.CONST -> 2 to Constants.PATTERN_CONST_BOOL
        }

        val matcher = pattern.matcher(line)
        return matcher.matches() && matcher.group(idx).matches(name.toRegex())
    }

    override fun checkUsed() = false

    override fun isUsedInLine(line: String) = false


}