package net.bloom.bloomclient.value.values.shaders

import net.bloom.bloomclient.utils.Constants
import net.bloom.bloomclient.value.values.BoolValue

class ShaderBoolValue(
    name: String,
    description: String,
    value: Boolean,
    val path: String,
    val type: VariableType
): BoolValue(name, description, value, { true }, null, false), IShaderOption {
    override val paths = mutableSetOf(path)

    override fun getSourceLine() = when (type) {
        VariableType.DEFINE -> if (value) "#define $name // Shader option ON" else "//#define $name // Shader option OFF"
        VariableType.CONST -> "const bool $name = $value; // Shader option $displayedValue"
    }

    override val displayedValue: String
        get() = if (value) "ON" else "OFF"

    override fun matchesLine(line: String): Boolean {
        val (idx, pattern) = when (type) {
            VariableType.DEFINE -> 2 to Constants.PATTERN_DEFINE
            VariableType.CONST -> 1 to Constants.PATTERN_CONST_BOOL
        }

        val matcher = pattern.matcher(line)
        return matcher.matches() && matcher.group(idx).matches(name.toRegex())
    }

    override fun checkUsed() = false

    override fun isUsedInLine(line: String): Boolean {
        if (type == VariableType.CONST)
            return false

        val matcher = Constants.PATTERN_IFDEF.matcher(line)
        return matcher.matches() && matcher.group(2) == name
    }

}