package net.bloom.bloomclient.value.values

import com.google.gson.JsonElement
import com.google.gson.JsonPrimitive
import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.value.Value

open class TextValue(
    name: String,
    description: String,
    value: String,
    displayable: () -> Boolean,
    owner: Configurable,
    applySettingOnThread: Boolean
): Value<String>(name, description, value, displayable, owner, applySettingOnThread) {
    override fun toJson() = JsonPrimitive(value)

    override fun fromJson(element: JsonElement) {
        if (element.isJsonPrimitive)
            changeValue(element.asString)
    }
}