package net.bloom.bloomclient.value.values

import com.google.gson.JsonElement
import com.google.gson.JsonPrimitive
import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.value.Value

open class ListValue(
    name: String,
    description: String,
    value: String,
    values: Array<String>,
    displayable: () -> Boolean,
    owner: Configurable?,
    applySettingOnThread: Boolean
): Value<String>(name, description, value, displayable, owner, applySettingOnThread) {
    var values = values
        set(values) {
            field = values
            val idx = values.indexOf(value)
            if (idx == -1) {
                currentValueIndex = 0
                value = values.first()
            } else {
                currentValueIndex = idx
            }
        }

    var currentValueIndex = values.indexOf(value)


    constructor(name: String, value: String, values: Array<String>, owner: Configurable): this(name, "No description available.", value, values, { true }, owner, false)

    constructor(name: String, values: Array<String>, owner: Configurable): this(name, "No description available.", values.first(), values, { true }, owner, false)


    override fun toJson() = JsonPrimitive(value)
    operator fun contains(input: String?) = values.any { it.equals(input, true) }
    override fun equals(other: Any?): Boolean = value.equals(other.toString(), true)

    override fun changeValue(newValue: String) {
        if (newValue in values) {
            value = newValue
            syncValue()
            currentValueIndex = values.indexOf(value)
        }
    }
    override fun fromJson(element: JsonElement) {
        if (element.isJsonPrimitive)
            changeValue(element.asString)
    }

    override fun fromProperties(value: Any?) {
        if (value is String)
            changeValue(value)
    }

    fun nextTemporaryValue() {
        currentValueIndex = (currentValueIndex + 1) % values.size
        temporaryValue = values[currentValueIndex]
    }
}