package net.bloom.bloomclient.value.values

import com.google.gson.JsonElement
import com.google.gson.JsonPrimitive
import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.value.Value
import org.lwjgl.input.Keyboard

open class KeyValue(
    name: String,
    description: String,
    value: Int,
    displayable: () -> Boolean,
    owner: Configurable,
    applySettingOnThread: Boolean
): Value<Int>(name, description, value, displayable, owner, applySettingOnThread) {

    var isKeyDown = false
    var pressTime = 0

    val keyCode: Int
        get() = value

    fun isPressed(): Boolean {
        return if (pressTime == 0) {
            false
        } else {
            --pressTime
            true
        }
    }

    fun unpressKey() {
        pressTime = 0
        isKeyDown = false
    }

    override val displayedValue: String
        get() = when (temporaryValue) {
            -100 -> "Left click"
            -99 -> "Right click"
            -98 -> "Middle click"
            else -> Keyboard.getKeyName(temporaryValue) ?: "UNKNOWN"
        }

    override fun toJson() = JsonPrimitive(value)

    override fun fromJson(element: JsonElement) {
        if (element.isJsonPrimitive) {
            value = element.asInt
            temporaryValue = value
        }
    }


}