package net.bloom.bloomclient.value.values

import com.google.gson.JsonElement
import com.google.gson.JsonPrimitive
import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.value.Value

open class IntegerValue(
    name: String,
    description: String,
    value: Int,
    val minRange: Int = 0,
    val maxRange: Int = Int.MAX_VALUE,
    val suffix: String,
    displayable: () -> Boolean,
    owner: Configurable?,
    applySettingOnThread: Boolean
): Value<Int>(name, description, value, displayable, owner, applySettingOnThread) {

    constructor(name: String, value: Int, minRange: Int, maxRange: Int, owner: Configurable): this(name, "No description available", value, minRange, maxRange, "", { true }, owner, false)

    val deltaRange: Int
        get() = maxRange - minRange

    override fun toJson() = JsonPrimitive(value)

    override fun fromJson(element: JsonElement) {
        if (element.isJsonPrimitive)
            changeValue(element.asInt)
    }

    override fun fromProperties(value: Any?) {
        if (value is Int) {
            temporaryValue = value
            this.value = value
        }
    }
}