package net.bloom.bloomclient.value.values

import com.google.gson.Gson
import com.google.gson.JsonElement
import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.value.range.IntegerRange
import net.bloom.bloomclient.value.Value

open class IntRangeValue(
    name: String,
    description: String,
    minValue: Int,
    maxValue: Int,
    val minRange: Int,
    val maxRange: Int,
    val suffix: String,
    displayable: () -> Boolean,
    owner: Configurable,
    applySettingOnThread: Boolean
): Value<IntegerRange>(name, description, IntegerRange(minValue, maxValue), displayable, owner, applySettingOnThread) {
    val deltaRange: Int
        get() = maxRange - minRange

    override fun toJson(): JsonElement = Gson().toJsonTree(value)

    override fun fromJson(element: JsonElement) {
        if (element.isJsonObject) {
            value.minimum = element.asJsonObject["minimum"].asInt
            value.maximum = element.asJsonObject["maximum"].asInt
        }
    }
}