package net.bloom.bloomclient.value.values

import com.google.gson.JsonElement
import com.google.gson.JsonObject
import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.value.Value

/**
 * A group value for wrap settings to a group
 * @author toidicakhia
 */
class GroupValue(
    name: String,
    description: String,
    value: Array<Value<*>>,
    displayable: () -> Boolean,
    owner: Configurable?,
    applySettingOnThread: Boolean
): Value<Array<Value<*>>>(name, description, value, displayable, owner, applySettingOnThread) {
    var isListOpen = false

    override fun toJson(): JsonElement {
        val json = JsonObject()

        for (item in value)
            json.add(item.name, item.toJson())

        return json
    }

    override fun fromJson(element: JsonElement) {
        if (element.isJsonObject) {
            for ((name, value) in element.asJsonObject.entrySet())
                this.value.find { it.name == name }?.fromJson(value)
        }
    }

}