package net.bloom.bloomclient.value.values

import com.google.gson.JsonElement
import com.google.gson.JsonPrimitive
import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.value.Value

open class FloatValue(
    name: String,
    description: String,
    value: Float,
    val minRange: Float = 0f,
    val maxRange: Float = Float.MAX_VALUE,
    val suffix: String,
    displayable: () -> Boolean,
    owner: Configurable,
    applySettingOnThread: Boolean
): Value<Float>(name, description, value, displayable, owner, applySettingOnThread) {

    constructor(name: String, value: Float, minRange: Float, maxRange: Float, owner: Configurable): this(name, "No description available", value, minRange, maxRange, "", { true }, owner, false)

    val deltaRange: Float
        get() = maxRange - minRange

    override fun toJson() = JsonPrimitive(value)

    override fun fromJson(element: JsonElement) {
        if (element.isJsonPrimitive)
            changeValue(element.asFloat)
    }

    override fun fromProperties(value: Any?) {
        if (value is Float) {
            temporaryValue = value
            this.value = value
        }
    }
}