package net.bloom.bloomclient.value.values

import com.google.gson.Gson
import com.google.gson.JsonElement
import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.utils.RandomUtils
import net.bloom.bloomclient.value.Value
import net.bloom.bloomclient.value.range.FloatRange

open class FloatRangeValue(
    name: String,
    description: String,
    minValue: Float,
    maxValue: Float,
    val minRange: Float,
    val maxRange: Float,
    val suffix: String,
    displayable: () -> Boolean,
    owner: Configurable,
    applySettingOnThread: Boolean
): Value<FloatRange>(name, description, FloatRange(minValue, maxValue), displayable, owner, applySettingOnThread) {
    val deltaRange: Float
        get() = maxRange - minRange

    fun random() = RandomUtils.nextFloat(value.minimum, value.maximum)

    override fun toJson(): JsonElement = Gson().toJsonTree(value)

    override fun fromJson(element: JsonElement) {
        if (element.isJsonObject) {
            value.minimum = element.asJsonObject["minimum"].asFloat
            value.maximum = element.asJsonObject["maximum"].asFloat
        }
    }
}