package net.bloom.bloomclient.value.values

import com.google.gson.JsonElement
import com.google.gson.JsonPrimitive
import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.value.Value

class EnumValue<T: Enum<T>>(
    name: String,
    description: String,
    value: T,
    val values: Array<T>,
    displayable: () -> Boolean,
    owner: Configurable,
    applySettingOnThread: Boolean
): Value<T>(name, description, value, displayable, owner, applySettingOnThread) {
    override fun toJson() = JsonPrimitive(value.name)

    override fun fromJson(element: JsonElement) {
        if (element.isJsonPrimitive)
            value = values.find { it.name == element.asString } ?: return
    }

    fun setValue(name: String) {
        val enumValue = values.find { it.name == name } ?: return
        set(enumValue)
    }

}