package net.bloom.bloomclient.value.values

import com.google.gson.JsonElement
import com.google.gson.JsonPrimitive
import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.value.Value

open class BoolValue(
    name: String,
    description: String,
    value: Boolean,
    displayable: () -> Boolean,
    owner: Configurable?,
    applySettingOnThread: Boolean
): Value<Boolean>(name, description, value, displayable, owner, applySettingOnThread) {
    constructor(name: String, value: Boolean, owner: Configurable): this(name, "No description available.", value, { true }, owner, false)

    override fun toJson() = JsonPrimitive(value)

    override fun fromJson(element: JsonElement) {
        if (element.isJsonPrimitive)
            changeValue(element.asBoolean || element.asString.equals("true", true))
    }

    override fun fromProperties(value: Any?) {
        if (value is Boolean) {
            temporaryValue = value
            this.value = value
        }
    }
}