package net.bloom.bloomclient.value.range

import net.bloom.bloomclient.utils.RandomUtils
import net.bloom.bloomclient.utils.extension.step
import net.bloom.bloomclient.utils.extension.until

open class Range<T>(var minimum: T, var maximum: T) where T : Number, T : Comparable<T> {
    fun correctRange() {
        val min = minimum
        val max = maximum

        if (min > max) {
            minimum = max
            maximum = min
        }
    }

    operator fun contains(value: T) = value in minimum..maximum

    val range: ClosedRange<T>
        get() = minimum..maximum
}

class IntegerRange(minimum: Int, maximum: Int): Range<Int>(minimum, maximum)

class FloatRange(minimum: Float, maximum: Float): Range<Float>(minimum, maximum) {
    val valueRangeDouble: ClosedFloatingPointRange<Double>
        get() = minimum.toDouble()..maximum.toDouble()

    fun random() = RandomUtils.nextFloat(minimum, maximum)

    fun getValueRangeFloat(stepValue: Float) = minimum until maximum step stepValue

    fun getValueRangeDouble(stepValue: Double) = minimum.toDouble() until maximum.toDouble() step stepValue
}