package net.bloom.bloomclient.utils.struct

class TickTimer {

    var ticks = 0

    fun waitTicks(reachedTicks: Int, func: () -> Unit) {
        ticks++

        if (ticks >= reachedTicks) {
            func()
            ticks = 0
        }
    }

    fun reset() {
        ticks = 0
    }

    fun update() {
        ticks++
    }

    fun hasTickReached(reachedTicks: Int) = ticks >= reachedTicks

}