package net.bloom.bloomclient.utils.struct

class MSTimer {
    var time = System.currentTimeMillis()

    fun hasTimeElapsed(delay: Long, reset: Boolean) =
        if (System.currentTimeMillis() - time > delay) {
            if (reset) reset()
            true
        } else false

    fun hasTimeElapsed(delay: Double, reset: Boolean) = hasTimeElapsed(delay.toLong(), reset)

    fun hasTimeElapsed(delay: Int, reset: Boolean) = hasTimeElapsed(delay.toLong(), reset)

    fun hasTimePassed(delay: Int) = hasTimePassed(delay.toLong())

    fun hasTimePassed(delay: Float) = hasTimePassed(delay.toLong())

    fun hasTimePassed(delay: Long) = System.currentTimeMillis() >= time + delay

    fun hasTimeLeft(delay: Long) = delay + time - System.currentTimeMillis()

    val reachedTime
        get() = System.currentTimeMillis() - time

    fun reset() {
        time = System.currentTimeMillis()
    }
}