package net.bloom.bloomclient.utils.render.skiko.gl

import java.util.*

/**
 * State Management Utility.
 * @author KhoiBruh
 */
object States {
    private val stateStack = Stack<State>()

    fun backup() {
        val currentState = State()
        currentState.backupCurrentState()
        stateStack.push(currentState)
    }

    fun restore() {
        if (stateStack.isNotEmpty()) {
            val previousState = stateStack.pop()
            previousState.restorePreviousState()
        }
    }
}