package net.bloom.bloomclient.utils.render.skiko.gl

import org.lwjgl.opengl.GL45.*

/**
 * A class to store and restore OpenGL state.
 * @author KhoiBruh
 */
class State {
    private val pixelStores = HashMap<PixelStoreParameter, Int>()
    private var lastActiveTexture = 0
    private var lastProgram = 0
    private var lastSampler = 0
    private var lastVertexArray = 0
    private var lastArrayBuffer = 0

    private var lastBlendSrcRgb = 0
    private var lastBlendDstRgb = 0
    private var lastBlendSrcAlpha = 0
    private var lastBlendDstAlpha = 0
    private var lastBlendEquationRgb = 0
    private var lastBlendEquationAlpha = 0

    fun backupCurrentState() {
        glPushClientAttrib(GL_CLIENT_ALL_ATTRIB_BITS)
        glPushAttrib(GL_ALL_ATTRIB_BITS)

        lastActiveTexture = glGetInteger(GL_ACTIVE_TEXTURE)
        lastProgram = glGetInteger(GL_CURRENT_PROGRAM)
        lastSampler = glGetInteger(GL_SAMPLER_BINDING)
        lastArrayBuffer = glGetInteger(GL_ARRAY_BUFFER_BINDING)
        lastVertexArray = glGetInteger(GL_VERTEX_ARRAY_BINDING)

        PixelStoreParameter.entries.forEach { pixelStores.put(it, glGetInteger(it.value)) }

        lastBlendSrcRgb = glGetInteger(GL_BLEND_SRC_RGB)
        lastBlendDstRgb = glGetInteger(GL_BLEND_DST_RGB)
        lastBlendSrcAlpha = glGetInteger(GL_BLEND_SRC_ALPHA)
        lastBlendDstAlpha = glGetInteger(GL_BLEND_DST_ALPHA)
        lastBlendEquationRgb = glGetInteger(GL_BLEND_EQUATION_RGB)
        lastBlendEquationAlpha = glGetInteger(GL_BLEND_EQUATION_ALPHA)
    }

    fun restorePreviousState() {
        glPopAttrib()
        glPopClientAttrib()

        glUseProgram(lastProgram)
        glBindSampler(0, lastSampler)
        glActiveTexture(lastActiveTexture)
        glBindVertexArray(lastVertexArray)
        glBindBuffer(GL_ARRAY_BUFFER, lastArrayBuffer)
        glBlendEquationSeparate(lastBlendEquationRgb, lastBlendEquationAlpha)
        glBlendFuncSeparate(lastBlendSrcRgb, lastBlendDstRgb, lastBlendSrcAlpha, lastBlendDstAlpha)

        PixelStoreParameter.entries.forEach { glPixelStorei(it.value, pixelStores[it]!!) }
    }
}
