package net.bloom.bloomclient.utils.render.skiko.font

import net.bloom.bloomclient.utils.render.skiko.Skiko.paint
import net.bloom.bloomclient.utils.render.skiko.SkikoContext.canvas
import org.jetbrains.skia.*
import java.awt.Color

/**
 * Skiko Font.
 * @author KhoiBruh
 */
class SkiaFont(val font: Font) {
    val metrics = font.metrics

    fun text(text: String, x: Float, y: Float, color: Color) {
        canvas.drawString(text, x, y, font, paint(color))
    }

    fun text(text: String, x: Float, y: Float, paint: Paint) {
        canvas.drawString(text, x, y, font, paint)
    }

    fun centeredText(text: String, x: Float, y: Float, color: Color) =
        text(text, x - (width(text) / 2),  y, color)

    fun centeredText(text: String, x: Float, y: Float, paint: Paint) =
        text(text, x - (width(text) / 2), y, paint)

    fun measure(text: String) = font.measureText(text)

    fun height(text: String) = measure(text).height

    fun width(text: String) = measure(text).width

    fun close() = font.close()
}