package net.bloom.bloomclient.utils.render.skiko.font

import org.jetbrains.skia.Data
import org.jetbrains.skia.Font
import org.jetbrains.skia.FontMgr

/**
 * A font manager for Skiko fonts.
 * @author KhoiBruh
 */
enum class Fonts(val fontName: String, val extension: String = ".ttf") {
    NUNITO("Nunito-%s");

    private val cache = HashMap<Float, SkiaFont>()

    operator fun get(size: Float, style: Style) = cache.computeIfAbsent(size) {
        val fontPath = String.format(fontName, style.name)
        val font = loadFont("$fontPath$extension", size)
        SkiaFont(font)
    }

    operator fun get(size: Float) = get(size, Style.REGULAR)

    fun loadFont(name: String, size: Float): Font {
        val classLoader = javaClass.classLoader
        val location = "assets/minecraft/bloomclient/font/$name"
        return classLoader
            .getResourceAsStream(location)
            .use { stream ->
                Data.makeFromBytes(stream.readBytes())
            }
            .let { data ->
                val face = FontMgr.default.makeFromData(data)
                data.close()
                Font(face, size)
            }
    }
}