package net.bloom.bloomclient.utils.render.skiko

import net.bloom.bloomclient.BloomClient
import net.bloom.bloomclient.utils.render.skiko.gl.States
import net.minecraft.client.MinecraftInstance
import net.minecraft.client.gui.ScaledResolution
import org.jetbrains.skia.*
import org.lwjgl.opengl.GL11.*

/**
 * Skiko Rendering Context
 * @author KhoiBruh
 */
object SkikoContext : MinecraftInstance() {
    private val context = DirectContext.makeGL()
    private lateinit var renderTarget: BackendRenderTarget
    lateinit var surface: Surface

    val canvas
        get() = surface.canvas

    private val scale: Float
        get() {
            val sr = ScaledResolution(mc)
            return sr.scaleFactor.toFloat()
        }

    init {
        BloomClient.eventManager.register(this)
    }

    fun createSurface(width: Int = mc.displayWidth, height: Int = mc.displayHeight) {
        val fbo = mc.framebuffer.framebufferObject
        renderTarget = BackendRenderTarget.makeGL(
            width, height,
            0, 8,
            fbo, GL_RGBA8
        )

        surface = Surface.makeFromBackendRenderTarget(
            context, renderTarget,
            SurfaceOrigin.BOTTOM_LEFT,
            SurfaceColorFormat.RGBA_8888,
            ColorSpace.sRGB
        ) ?: throw IllegalStateException("Failed to create surface")
    }

    fun onResize(width: Int, height: Int) {
        surface.close()
        renderTarget.close()
        createSurface(width, height)
    }

    fun preFlush() {
        States.backup()
        context.resetGLAll()
        glDisable(GL_ALPHA_TEST)

        // need to scale to match the scale of the game
        Skiko.save()
        Skiko.scale(scale)
    }

    fun flush() {
        // restore skiko state after scale
        Skiko.restore()

        context.flush()
        States.restore()
    }
}