package net.bloom.bloomclient.utils.render.shader.shaders.font

import net.bloom.bloomclient.utils.render.shader.Shader
import org.lwjgl.opengl.GL20.glUniform1f
import org.lwjgl.opengl.GL20.glUniform2f
import java.io.Closeable

object RainbowFontShader : Shader("rainbow_font.frag"), Closeable {
    var isInUse = false
        private set

    var strengthX = 0f
    var strengthY = 0f
    var offset = 0f

    override fun setupUniforms() {
        setupUniform("offset")
        setupUniform("strength")
    }

    override fun updateUniforms() {
        glUniform2f(getUniform("strength"), strengthX, strengthY)
        glUniform1f(getUniform("offset"), offset)
    }

    override fun startShader() {
        super.startShader()
        isInUse = true
    }

    override fun stopShader() {
        super.stopShader()
        isInUse = false
    }

    override fun close() {
        if (isInUse)
            stopShader()
    }

    fun begin(enable: Boolean, x: Float, y: Float, offset: Float): RainbowFontShader {
        if (enable) {
            strengthX = x
            strengthY = y
            RainbowFontShader.offset = offset

            startShader()
        }

        return this
    }
}