package net.bloom.bloomclient.utils.render

import net.bloom.bloomclient.utils.MathUtils.lerp
import net.bloom.bloomclient.utils.struct.MSTimer
import org.lwjgl.input.Mouse

/**
 * Smooth scrolling utility
 * @author KhoiBruh
 */
class ScrollUtils {
    private val scrollTimer = MSTimer()

    private val stretch = 30F
    private var target = 0F

    var scroll = 0F
        private set
    var max = 0F

    fun update() {
        if (scrollTimer.hasTimeElapsed(70L, true)) {
            val wheel = -Mouse.getDWheel() * stretch

            // This mean you can scroll over 30 pixels then it will snap back
            target = (target + wheel).coerceIn(
                if (wheel == 0F) 0F else -stretch,
                max + if (wheel == 0F) 0F else stretch
            )
        }

        // I think this is smooth and fast enough
        scroll = lerp(scroll, target, 0.15F)
    }

    // reset scrolling, of course
    fun reset() {
        scroll = 0F
        target = 0F
        scrollTimer.reset()
    }
}