package net.bloom.bloomclient.utils.render

import net.bloom.bloomclient.utils.Constants
import net.bloom.bloomclient.utils.render.GLUtils.glColor
import net.minecraft.client.MinecraftInstance
import net.minecraft.client.gui.ScaledResolution
import net.minecraft.client.renderer.GlStateManager
import net.minecraft.client.renderer.GlStateManager.glBegin
import net.minecraft.client.renderer.GlStateManager.glEnd
import net.minecraft.client.renderer.Tessellator
import net.minecraft.client.renderer.vertex.DefaultVertexFormats
import net.minecraft.util.AxisAlignedBB
import net.minecraft.util.Vec3
import org.lwjgl.opengl.GL11.*
import java.awt.Color
import kotlin.math.cos
import kotlin.math.sin


object RenderUtils: MinecraftInstance() {
    fun drawRoundedRect(startX: Float, startY: Float, endX: Float, endY: Float, radius: Float, color: Color) {
        drawRect(startX, startY, endX, endY, radius, color,
            roundTL = true, roundTR = true, roundBL = true, roundBR = true)
    }

    fun drawBorderRect(startX: Number, startY: Number, endX: Number, endY: Number, color: Color = Color.WHITE, borderWidth: Float = 1f) {
        drawRect(startX.toFloat(), startY.toFloat(), endX.toFloat(), endY.toFloat(), 0f, color,
            roundTL = false,
            roundTR = false,
            roundBL = false,
            roundBR = false,
            border = true,
            borderWidth = borderWidth,
        )
    }

    fun drawOutlinedBoundingBox(aabb: AxisAlignedBB, lineWidth: Float, color: Color) {
        val tessellator = Tessellator.getInstance()
        val worldRenderer = tessellator.worldRenderer

        glPushMatrix()
        glEnable(GL_BLEND)
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        glEnable(GL_LINE_SMOOTH)
        glHint(GL_LINE_SMOOTH_HINT, GL_NICEST)
        glDisable(GL_TEXTURE_2D)
        glDisable(GL_DEPTH_TEST)
        glDepthMask(false)

        glLineWidth(lineWidth)
        glColor4f(
            color.red / 255f,
            color.green / 255f,
            color.blue / 255f,
            color.alpha / 255f
        )

        // Start drawing lines
        worldRenderer.begin(GL_LINE_STRIP, DefaultVertexFormats.POSITION)

        // Bottom face
        worldRenderer.pos(aabb.minX, aabb.minY, aabb.minZ).endVertex()
        worldRenderer.pos(aabb.minX, aabb.minY, aabb.maxZ).endVertex()
        worldRenderer.pos(aabb.maxX, aabb.minY, aabb.maxZ).endVertex()
        worldRenderer.pos(aabb.maxX, aabb.minY, aabb.minZ).endVertex()
        worldRenderer.pos(aabb.minX, aabb.minY, aabb.minZ).endVertex()

        // Vertical edges
        worldRenderer.pos(aabb.minX, aabb.maxY, aabb.minZ).endVertex()
        worldRenderer.pos(aabb.minX, aabb.maxY, aabb.maxZ).endVertex()
        worldRenderer.pos(aabb.maxX, aabb.maxY, aabb.maxZ).endVertex()
        worldRenderer.pos(aabb.maxX, aabb.maxY, aabb.minZ).endVertex()
        worldRenderer.pos(aabb.minX, aabb.maxY, aabb.minZ).endVertex()

        // Top face
        worldRenderer.pos(aabb.minX, aabb.maxY, aabb.maxZ).endVertex()
        worldRenderer.pos(aabb.maxX, aabb.maxY, aabb.maxZ).endVertex()
        worldRenderer.pos(aabb.maxX, aabb.maxY, aabb.minZ).endVertex()
        worldRenderer.pos(aabb.minX, aabb.maxY, aabb.minZ).endVertex()

        tessellator.draw()

        // Draw the remaining vertical lines
        worldRenderer.begin(GL_LINES, DefaultVertexFormats.POSITION)
        worldRenderer.pos(aabb.minX, aabb.minY, aabb.maxZ).endVertex()
        worldRenderer.pos(aabb.minX, aabb.maxY, aabb.maxZ).endVertex()

        worldRenderer.pos(aabb.maxX, aabb.minY, aabb.maxZ).endVertex()
        worldRenderer.pos(aabb.maxX, aabb.maxY, aabb.maxZ).endVertex()

        worldRenderer.pos(aabb.maxX, aabb.minY, aabb.minZ).endVertex()
        worldRenderer.pos(aabb.maxX, aabb.maxY, aabb.minZ).endVertex()

        tessellator.draw()

        // Restore GL state
        glEnable(GL_DEPTH_TEST)
        glDepthMask(true)
        glEnable(GL_TEXTURE_2D)
        glDisable(GL_LINE_SMOOTH)
        glDisable(GL_BLEND)
        glPopMatrix()
    }

    fun drawBorderRect(startX: Float, startY: Float, endX: Float, endY: Float, color: Color = Color.WHITE, borderWidth: Float = 1f) {
        drawRect(startX, startY, endX, endY, 0f, color,
            roundTL = false,
            roundTR = false,
            roundBL = false,
            roundBR = false,
            border = true,
            borderWidth = borderWidth,
        )
    }


    fun drawRect(startXIn: Int, startYIn: Int, endXIn: Int, endYIn: Int, color: Color) {
        drawRect(startXIn.toFloat(), startYIn.toFloat(), endXIn.toFloat(), endYIn.toFloat(), color = color)
    }

    @JvmOverloads
	fun drawRect(
        startXIn: Float, startYIn: Float, endXIn: Float, endYIn: Float, 
        radius: Float = 0f, color: Color = Color.WHITE,
        roundTL: Boolean = false, roundTR: Boolean = false,
        roundBL: Boolean = false, roundBR: Boolean = false,
        border: Boolean = false, borderWidth: Float = 1f) {

        val (startX, endX) = if (startXIn > endXIn) endXIn to startXIn else startXIn to endXIn
        val (startY, endY) = if (startYIn > endYIn) endYIn to startYIn else startYIn to endYIn

        val x1 = startX + radius
        val y1 = startY + radius
        val x2 = endX - radius
        val y2 = endY - radius

        glPushMatrix()
        glEnable(GL_BLEND)
        glDisable(GL_TEXTURE_2D)
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        glEnable(GL_LINE_SMOOTH)
        glLineWidth(if (border) borderWidth else 1f)
        glColor(color)
        glBegin(if (border) GL_LINE_LOOP else GL_POLYGON)

        if (radius == 0f || !roundBR)
            glVertex2f(endX, endY)
        else
            drawPartOfCircle(x2, y2, radius, 0, 90)

        if (radius == 0f || !roundTR)
            glVertex2f(endX, startY)
        else
            drawPartOfCircle(x2, y1, radius, 90, 180)

        if (radius == 0f || !roundTL)
            glVertex2f(startX, startY)
        else
            drawPartOfCircle(x1, y1, radius, 180, 270)

        if (radius == 0f || !roundBL)
            glVertex2f(startX, endY)
        else
            drawPartOfCircle(x1, y2, radius, 270, 360)

        glEnd()
        glEnable(GL_TEXTURE_2D)
        glDisable(GL_BLEND)
        glDisable(GL_LINE_SMOOTH)
        glPopMatrix()
    }

    fun drawPartOfCircle(x: Float, y: Float, radius: Float, start: Int, end: Int) {
        for (i in start..end) {
            val angle = Constants.PI_PER_DEGREE * i
            glVertex2d(x + sin(angle) * radius, y + cos(angle) * radius)
        }
    }

    fun renderScissorBox(x: Float, y: Float, x2: Float, y2: Float, renderFunc: () -> Unit) {
        renderScissorBox(x.toDouble(), y.toDouble(), x2.toDouble(), y2.toDouble(), renderFunc)
    }

    fun renderScissorBox(x: Double, y: Double, x2: Double, y2: Double, renderFunc: () -> Unit) {
        glPushMatrix()
        glEnable(3089)
        val sc = ScaledResolution(mc)
        val factor = sc.scaleFactor
        glScissor(
            (x * factor).toInt(),
            ((sc.scaledHeight - y2) * factor).toInt(),
            ((x2 - x) * factor).toInt(),
            ((y2 - y) * factor).toInt()
        )
        renderFunc()
        glDisable(3089)
        glPopMatrix()
    }

    fun drawLine(x: Double, y: Double, x1: Double, y1: Double, width: Float) {
        glDisable(GL_TEXTURE_2D)
        glLineWidth(width)
        glBegin(GL_LINES)
        glVertex2d(x, y)
        glVertex2d(x1, y1)
        glEnd()
        glEnable(GL_TEXTURE_2D)
    }

    fun drawBoundingBox(boundingBox: AxisAlignedBB, color: Color) {
        val tessellator = Tessellator.getInstance()
        val worldRenderer = tessellator.worldRenderer
        worldRenderer.begin(7, DefaultVertexFormats.POSITION_COLOR)
        worldRenderer.pos(boundingBox.minX, boundingBox.minY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.maxY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.minY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.maxY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.minY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.minY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.maxY, boundingBox.maxZ).color(color).endVertex()
        tessellator.draw()
        worldRenderer.begin(7, DefaultVertexFormats.POSITION_COLOR)
        worldRenderer.pos(boundingBox.maxX, boundingBox.maxY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.minY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.maxY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.minY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.maxY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.minY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.minY, boundingBox.maxZ).color(color).endVertex()
        tessellator.draw()
        worldRenderer.begin(7, DefaultVertexFormats.POSITION_COLOR)
        worldRenderer.pos(boundingBox.minX, boundingBox.maxY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.maxY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.maxY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.maxY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.maxY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.maxY, boundingBox.minZ).color(color).endVertex()
        tessellator.draw()
        worldRenderer.begin(7, DefaultVertexFormats.POSITION_COLOR)
        worldRenderer.pos(boundingBox.minX, boundingBox.minY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.minY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.minY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.minY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.minY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.minY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.minY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.minY, boundingBox.minZ).color(color).endVertex()
        tessellator.draw()
        worldRenderer.begin(7, DefaultVertexFormats.POSITION_COLOR)
        worldRenderer.pos(boundingBox.minX, boundingBox.minY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.maxY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.minY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.maxY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.minY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.minY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.maxY, boundingBox.minZ).color(color).endVertex()
        tessellator.draw()
        worldRenderer.begin(7, DefaultVertexFormats.POSITION_COLOR)
        worldRenderer.pos(boundingBox.minX, boundingBox.maxY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.minY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.maxY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.minX, boundingBox.minY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.maxY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.minY, boundingBox.minZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ).color(color).endVertex()
        worldRenderer.pos(boundingBox.maxX, boundingBox.minY, boundingBox.maxZ).color(color).endVertex()
        tessellator.draw()
    }

    fun drawPosByVec(pos: Vec3, color: Color) {
        GlStateManager.pushMatrix()
        val x = pos.xCoord - mc.renderManager.viewerPosX
        val y = pos.yCoord - mc.renderManager.viewerPosY
        val z = pos.zCoord - mc.renderManager.viewerPosZ
        val box = mc.thePlayer.entityBoundingBox.expand(0.1, 0.1, 0.1)
        val axis = AxisAlignedBB(
            box.minX - mc.thePlayer.posX + x,
            box.minY - mc.thePlayer.posY + y,
            box.minZ - mc.thePlayer.posZ + z,
            box.maxX - mc.thePlayer.posX + x,
            box.maxY - mc.thePlayer.posY + y,
            box.maxZ - mc.thePlayer.posZ + z
        )

        glBlendFunc(770, 771)
        glEnable(3042)
        glDisable(3553)
        glDisable(2929)
        glDepthMask(false)
        glLineWidth(2.0f)
        glColor(color)
        drawOutlinedBoundingBox(axis, 2.0F, color)
        glEnable(3553)
        glEnable(2929)
        glDepthMask(true)
        glDisable(3042)
        GlStateManager.popMatrix()
    }

    fun makeScissorBox(x: Float, y: Float, x2: Float, y2: Float) {
        val scaledResolution = ScaledResolution(mc)
        val factor = scaledResolution.scaleFactor
        glScissor(
            (x * factor).toInt(),
            ((scaledResolution.scaledHeight - y2) * factor).toInt(),
            ((x2 - x) * factor).toInt(),
            ((y2 - y) * factor).toInt()
        )
    }
}