package net.bloom.bloomclient.utils.player

import net.minecraft.client.MinecraftInstance
import net.minecraft.item.ItemPotion
import net.minecraft.item.ItemStack

object PotionUtils: MinecraftInstance() {

    private val GOOD_POTIONS = hashMapOf(
        6 to 1, // Instant Health
        10 to 2, // Regeneration
        11 to 3, // Resistance
        21 to 4, // Health Boost
        22 to 5, // Absorption
        23 to 6, // Saturation
        5 to 7, // Strength
        1 to 8, // Speed
        12 to 9, // Fire Resistance
        14 to 10, // Invisibility
        3 to 11, // Haste
        13 to 12 // Water Breathing
    )

    /**
     * Checks if a potion is good
     *
     * @return good potion
     */
    fun goodPotion(id: Int): Boolean {
        return GOOD_POTIONS.containsKey(id)
    }

    /**
     * Gets a potions ranking
     *
     * @return potion ranking
     */
    fun potionRanking(id: Int): Int {
        return GOOD_POTIONS.getOrDefault(id, -1)
    }

    fun isHealPotion(stack: ItemStack): Boolean {
        val itempotion = ItemPotion()
        val effects = itempotion.getEffects(stack)
        for (effect in effects) {
            if (effect.effectName == "potion.heal") return true
        }
        return false
    }

    fun getHealPotion(): Int {
        for (i in 36..44) {
            val stack = mc.thePlayer.inventoryContainer.getSlot(i).stack
            if(stack != null && stack.item is ItemPotion && isHealPotion(stack)) return i - 36
        }
        return -1
    }
}