package net.bloom.bloomclient.utils.player

import net.bloom.bloomclient.BloomClient
import net.bloom.bloomclient.event.KnockbackEvent
import net.bloom.bloomclient.features.module.modules.movement.ModuleSprint
import net.bloom.bloomclient.utils.BlockUtils
import net.minecraft.block.Block
import net.minecraft.block.BlockAir
import net.minecraft.block.BlockIce
import net.minecraft.block.BlockPackedIce
import net.minecraft.client.MinecraftInstance
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.enchantment.EnchantmentHelper
import net.minecraft.entity.Entity
import net.minecraft.entity.EntityLivingBase
import net.minecraft.entity.EnumCreatureAttribute
import net.minecraft.entity.SharedMonsterAttributes
import net.minecraft.entity.player.EntityPlayer
import net.minecraft.item.ItemMap
import net.minecraft.potion.Potion
import net.minecraft.util.*


object PlayerUtils: MinecraftInstance() {

    /**
     * Gets the block at a position
     *
     * @return block
     */
    fun block(x: Double, y: Double, z: Double): Block {
        return mc.theWorld.getBlockState(BlockPos(x, y, z)).block
    }

    fun isPlayerNearBlockInRange(range: Int): Boolean {
        for (x in -range..range) {
            for (y in -range..range) {
                for (z in -range..range) {
                    if (BlockUtils.getRelativeBlock(x, y, z) !is BlockAir)
                        return true
                }
            }
        }

        return false
    }

    val isOnEdge: Boolean
        get() = mc.thePlayer.onGround && !mc.thePlayer.isSneaking && !KeyBinding.keyBindSneak.isKeyDown && !KeyBinding.keyBindJump.isKeyDown && mc.theWorld.getCollidingBoundingBoxes(mc.thePlayer, mc.thePlayer.entityBoundingBox.offset(0.0, -0.5, 0.0).expand(-0.001, 0.0, -0.001)).isEmpty()

    val isOnIce: Boolean
        get() {
            val player = mc.thePlayer
            val blockUnder = mc.theWorld.getBlockState(BlockPos(player.posX, player.posY - 1.0, player.posZ)).block
            return blockUnder is BlockIce || blockUnder is BlockPackedIce
        }

    val isBlockUnder: Boolean
        get() {
            if (mc.thePlayer == null) return false
            if (mc.thePlayer.posY < 0.0) {
                return false
            }
            var off = 0
            while (off < mc.thePlayer.posY.toInt() + 2) {
                val bb = mc.thePlayer.entityBoundingBox.offset(0.0, -off.toDouble(), 0.0)
                if (mc.theWorld.getCollidingBoundingBoxes(mc.thePlayer, bb)?.isNotEmpty() == true)
                    return true

                off += 2
            }
            return false
        }

    val isPlayerHeldMap: Boolean
        get() {
            val heldItem = mc.thePlayer?.heldItem?.item ?: return false
            return heldItem is ItemMap
        }

    fun calculatePlayerPositionByTicks(entity: EntityPlayer, predictTicks: Int): Vector2Pos {
        val diffX = entity.prevPosX - entity.posX
        val diffZ = entity.prevPosZ - entity.posZ
        var posX = entity.posX
        var posZ = entity.posZ
        for (i in 0..predictTicks) {
            posX -= diffX * i
            posZ -= diffZ * i
        }

        return Vector2Pos(posX, posZ)
    }


    fun calculatePredictPosition(isHitting: Boolean, targetEntity: Entity, forward: Float, strafe: Float, yaw: Float): Vec3 {
        val vectorMovement = VectorMovement(strafe * 0.98f, forward * 0.98f)

        var f4 = 0.91f
        var motionX = mc.thePlayer.motionX
        var motionZ = mc.thePlayer.motionZ
        var motionY = mc.thePlayer.motionY
        var isSprinting = mc.thePlayer.isSprinting

        if (isHitting) {
            val attackDamage = mc.thePlayer.getEntityAttribute(SharedMonsterAttributes.attackDamage).attributeValue.toFloat()
            val enchantmentDamage = if (targetEntity is EntityLivingBase) {
                EnchantmentHelper.getModifierForCreature(mc.thePlayer.heldItem, targetEntity.creatureAttribute)
            } else {
                EnchantmentHelper.getModifierForCreature(mc.thePlayer.heldItem, EnumCreatureAttribute.UNDEFINED)
            }

            if (attackDamage > 0.0f || enchantmentDamage > 0.0f) {
                var knockbackModifier = EnchantmentHelper.getKnockbackModifier(mc.thePlayer)

                if (mc.thePlayer.isSprinting)
                    knockbackModifier++

                val attacked = targetEntity.attackEntityFrom(DamageSource.causePlayerDamage(mc.thePlayer), attackDamage)
                if (attacked) {
                    if (knockbackModifier > 0) {
                        val event = KnockbackEvent(0.6, false, 1, false, false, true)
                        BloomClient.eventManager.call(event)

                        if(!event.isCancelled){
                            motionX *= event.motion
                            motionZ *= event.motion
                            isSprinting = false
                        }
                    }
                }
            }
        }

        if (mc.thePlayer.isJumping && mc.thePlayer.onGround && mc.thePlayer.jumpTicks == 0) {
            motionY = 0.42
            if (mc.thePlayer.isPotionActive(Potion.jump))
                motionY += (mc.thePlayer.getActivePotionEffect(Potion.jump).amplifier + 1) * 0.1f

            if (isSprinting) {
                val yawRadians = yaw * 0.017453292f
                motionX -= MathHelper.sin(yawRadians) * 0.2f
                motionZ += MathHelper.cos(yawRadians) * 0.2f
            }
        }

        if (mc.thePlayer.onGround) {
            val blockPos = BlockPos(mc.thePlayer.posX.toInt(), mc.thePlayer.entityBoundingBox.minY.toInt() - 1, mc.thePlayer.posZ.toInt())
            f4 = mc.thePlayer.worldObj.getBlockState(blockPos).block.slipperiness * 0.91f
        }

        val friction = if (mc.thePlayer.onGround) {
            var moveSpeed = mc.thePlayer.aiMoveSpeed * (0.16277136f / (f4 * f4 * f4))
            if (ModuleSprint.state)
                moveSpeed = 0.12999998f

            moveSpeed
        } else {
            mc.thePlayer.jumpMovementFactor
        }

        val distance = vectorMovement.strafe * vectorMovement.strafe + vectorMovement.forward * vectorMovement.forward
        if (distance >= 1.0E-4f) {
            val normalized = MathHelper.sqrt_float(distance).coerceAtLeast(1.0f)
            val scale = friction / normalized
            vectorMovement.strafe *= scale
            vectorMovement.forward *= scale
            val yawRadians = yaw * Math.PI.toFloat() / 180.0f
            motionX += vectorMovement.strafe * MathHelper.cos(yawRadians) - vectorMovement.forward * MathHelper.sin(yawRadians)
            motionZ += vectorMovement.forward * MathHelper.cos(yawRadians) + vectorMovement.strafe * MathHelper.sin(yawRadians)
        }

        motionY *= 0.9800000190734863
        motionX *= f4
        motionZ *= f4

        return Vec3(motionX, motionY, motionZ)
    }

    fun getPredictedPos(
        forward: Float,
        strafe: Float,
        motionX: Double,
        motionY: Double,
        motionZ: Double,
        posX: Double,
        posY: Double,
        posZ: Double,
        isJumping: Boolean,
        yaw: Float,
    ): PlayerPosition {
        val vectorMovement = VectorMovement(strafe * 0.98f, forward * 0.98f)
        val vectorMotion = Vector3Pos(motionX, motionY, motionZ)

        var f4 = 0.91f
        val isSprinting = mc.thePlayer.isSprinting

        if (isJumping && mc.thePlayer.onGround && mc.thePlayer.jumpTicks == 0) {
            vectorMotion.y = 0.42
            if (mc.thePlayer.isPotionActive(Potion.jump))
                vectorMotion.y += (mc.thePlayer.getActivePotionEffect(Potion.jump).amplifier + 1) * 0.1f

            if (isSprinting) {
                val yawRadians = yaw * 0.017453292f
                vectorMotion.x -= MathHelper.sin(yawRadians) * 0.2f
                vectorMotion.z += MathHelper.cos(yawRadians) * 0.2f
            }
        }

        if (mc.thePlayer.onGround) {
            val blockPos = BlockPos(posX.toInt(), posY.toInt() - 1, posZ.toInt())
            f4 = mc.thePlayer.worldObj.getBlockState(blockPos).block.slipperiness * 0.91f
        }

        val f6 = 0.16277136f / (f4 * f4 * f4)
        val friction = if (mc.thePlayer.onGround) {
            var moveSpeed = mc.thePlayer.aiMoveSpeed * f6
            if (ModuleSprint.state)
                moveSpeed = 0.12999998f

            moveSpeed
        } else {
            mc.thePlayer.jumpMovementFactor
        }

        var f7 = vectorMovement.strafe * vectorMovement.strafe + vectorMovement.forward * vectorMovement.forward
        if (f7 >= 1.0E-4f) {
            f7 = MathHelper.sqrt_float(f7)

            if (f7 < 1.0f)
                f7 = 1.0f
            f7 = friction / f7
            vectorMovement.strafe *= f7
            vectorMovement.forward *= f7
            val yawRadians = yaw * Math.PI.toFloat() / 180.0f
            val f8 = MathHelper.sin(yawRadians)
            val f9 = MathHelper.cos(yawRadians)
            vectorMotion.x += vectorMovement.strafe * f9 - vectorMovement.forward * f8
            vectorMotion.z += vectorMovement.forward * f9 + vectorMovement.strafe * f8
        }

        val newPosX = posX + vectorMotion.x
        val newPosY = posY + motionY
        val newPosZ = posZ + vectorMotion.z

        f4 = 0.91f
        if (mc.thePlayer.onGround) {
            val blockPos = BlockPos(newPosX.toInt(), mc.thePlayer.entityBoundingBox.minY.toInt() - 1, newPosZ.toInt())
            f4 = mc.thePlayer.worldObj.getBlockState(blockPos).block.slipperiness * 0.91f
        }

        val blockPos = BlockPos(newPosX.toInt(), 0, newPosZ.toInt())

        if (mc.thePlayer.worldObj.isRemote && (!mc.thePlayer.worldObj.isBlockLoaded(blockPos) || !mc.thePlayer.worldObj.getChunkFromBlockCoords(blockPos).isLoaded)) {
            vectorMotion.y = if (newPosY > 0.0) -0.1 else 0.0
        } else {
            vectorMotion.y -= 0.08
        }

        vectorMotion.y *= 0.9800000190734863
        vectorMotion.x *= f4
        vectorMotion.z *= f4

        return PlayerPosition(forward, strafe, motionX, motionY, motionZ, newPosX, newPosY, newPosZ, isJumping, yaw)
    }

    /**
     * Checks if the player is inside a block
     *
     * @return inside block
     */
    fun insideBlock(): Boolean {
        if (mc.thePlayer.ticksExisted < 5)
            return false

        val bb = mc.thePlayer.entityBoundingBox
        for (x in bb.minX.toInt() until bb.maxX.toInt() + 1) {
            for (y in bb.minY.toInt() until bb.maxY.toInt() + 1) {
                for (z in bb.minZ.toInt() until bb.maxZ.toInt() + 1) {
                    val blockPos = BlockPos(x, y, z)
                    val block = mc.theWorld.getBlockState(blockPos).block
                    val boundingBox = block.getCollisionBoundingBox(mc.theWorld, blockPos, mc.theWorld.getBlockState(blockPos))
                    if (block != null && block !is BlockAir && boundingBox != null && mc.thePlayer.entityBoundingBox.intersectsWith(boundingBox))
                        return true
                }
            }
        }

        return false
    }
}