package net.bloom.bloomclient.utils.player


import net.minecraft.client.option.options.devices.KeyBinding
import net.bloom.bloomclient.utils.Constants
import net.bloom.bloomclient.utils.extension.toRadians
import net.minecraft.client.MinecraftInstance
import net.minecraft.potion.Potion
import net.minecraft.util.MathHelper
import net.minecraft.util.Rotation
import net.minecraft.util.Vector2Pos
import net.minecraft.util.VectorMovement
import kotlin.math.*


object MovementUtils: MinecraftInstance() {

	val isMoving: Boolean
		get() = Constants.MOVING_KEYS.any { it.isKeyDown }

	private val keyPressedNumber: Int
		get() = Constants.MOVING_KEYS.count { it.isKeyDown }

	val baseMoveSpeed: Double
		get() {
			var baseSpeed = 0.2873
			if (mc.thePlayer.isPotionActive(Potion.moveSpeed))
				baseSpeed *= 1.0 + 0.2 * (mc.thePlayer.getActivePotionEffect(Potion.moveSpeed).amplifier + 1)

			return baseSpeed
		}

	fun getJumpBoostModifier(baseJumpHeight: Float): Double {
		return getJumpBoostModifier(baseJumpHeight, true)
	}

	fun getJumpBoostModifier(baseJumpHeight: Float, potionJump: Boolean): Double {
		var jumpHeight = baseJumpHeight
		if (mc.thePlayer.isPotionActive(Potion.jump) && potionJump) {
			val amplifier = mc.thePlayer.getActivePotionEffect(Potion.jump).amplifier
			jumpHeight += (amplifier + 1) * 0.1f
		}
		return jumpHeight.toDouble()
	}

	fun getDirection(yaw: Float): Float {
		var rotationYaw = yaw

		if (KeyBinding.keyBindBack.isKeyDown)
			rotationYaw = yaw + 180.0f

		var forward = 1.0f
		if (KeyBinding.keyBindBack.isKeyDown)
			forward = -0.5f
		else if (KeyBinding.keyBindForward.isKeyDown)
			forward = 0.5f

		if (KeyBinding.keyBindLeft.isKeyDown)
			rotationYaw -= 90.0f * forward

		if (KeyBinding.keyBindRight.isKeyDown)
			rotationYaw += 90.0f * forward

		return MathHelper.wrapAngleTo180(rotationYaw)
	}

	fun getDirectionToRadians(yaw: Float) = getDirection(yaw).toDouble().toRadians()

	fun preventDiagonalSpeed() {
		if (keyPressedNumber == 1)
			return

		val groundIncrease = (0.1299999676734952 - 0.12739998266255503) + 1E-7 - 1E-8
		val airIncrease = (0.025999999334873708 - 0.025479999685988748) - 1E-8
		val increase = if (mc.thePlayer.onGround) groundIncrease else airIncrease

		boost(-increase)
	}

	fun boost(speed: Double) {
		if (!isMoving)
			return

		val yaw = getDirectionToRadians(mc.thePlayer.playerYaw)
		mc.thePlayer.motionX += -sin(yaw) * speed
		mc.thePlayer.motionZ += cos(yaw) * speed
	}

	fun strafe(speed: Double) {
		if (!isMoving)
			return

		val yaw = getDirectionToRadians(mc.thePlayer.playerYaw)
		mc.thePlayer.motionX = -sin(yaw) * speed
		mc.thePlayer.motionZ = cos(yaw) * speed
	}

	@JvmStatic
	fun handleSilentMove(strafe: Float, forward: Float, rotation: Rotation): VectorMovement {
		val realMotion = getMotion(strafe, forward, mc.thePlayer.playerYaw)
		val pos = Vector2Pos(mc.thePlayer.posX, mc.thePlayer.posZ) + realMotion

		val possibleForwardStrafe = listOf(
			VectorMovement(strafe - forward, strafe + forward),
			VectorMovement(-forward, strafe),
			VectorMovement(-strafe - forward, -forward + strafe),
			VectorMovement(-strafe, -forward),
			VectorMovement(-strafe + forward, -forward - strafe),
			VectorMovement(forward, -strafe),
			VectorMovement(strafe + forward, forward - strafe),
			VectorMovement(strafe, forward)
		)

		var distance = Double.MAX_VALUE
		var bestMovement = VectorMovement(strafe, forward)

		for (vector in possibleForwardStrafe) {
			vector.strafe = vector.strafe.coerceIn(-1f, 1f)
			vector.forward = vector.forward.coerceIn(-1f, 1f)

			val predictedMotion = getMotion(vector.strafe, vector.forward, rotation.yaw)
			val predictedPos = predictedMotion + Vector2Pos(mc.thePlayer.posX, mc.thePlayer.posZ)

			val diffX = abs(pos.x - predictedPos.x)
			val diffZ = abs(pos.z - predictedPos.z)

			val predictedDistance = diffX * diffX + diffZ * diffZ

			if (predictedDistance < distance) {
				distance = predictedDistance
				bestMovement = vector
			}
		}

		return bestMovement
    }

    fun getMotion(strafe: Float, forward: Float, yaw: Float): Vector2Pos {
        val friction = 0.22
        val f1 = sin(yaw * PI / 180f)
        val f2 = cos(yaw * PI / 180f)
        val motionX = strafe * friction * f2 - forward * friction * f1
        val motionZ = forward * friction * f2 + strafe * friction * f1
        return Vector2Pos(motionX, motionZ)
    }
}