package net.bloom.bloomclient.utils.player

import net.minecraft.block.Block
import net.minecraft.client.MinecraftInstance
import net.minecraft.init.Blocks
import net.minecraft.init.Items
import net.minecraft.inventory.IInventory
import net.minecraft.item.*
import net.minecraft.nbt.JsonToNBT
import net.minecraft.potion.Potion
import net.minecraft.util.ResourceLocation

object ItemUtils: MinecraftInstance() {
    val blacklistedBlocks = listOf(
        Blocks.air, Blocks.water, Blocks.flowing_water, Blocks.lava, Blocks.wooden_slab, Blocks.chest,
        Blocks.flowing_lava, Blocks.enchanting_table, Blocks.carpet, Blocks.glass_pane, Blocks.skull,
        Blocks.stained_glass_pane, Blocks.iron_bars, Blocks.snow_layer, Blocks.ice, Blocks.packed_ice,
        Blocks.coal_ore, Blocks.diamond_ore, Blocks.emerald_ore, Blocks.trapped_chest, Blocks.torch, Blocks.anvil,
        Blocks.noteblock, Blocks.jukebox, Blocks.tnt, Blocks.gold_ore, Blocks.iron_ore, Blocks.lapis_ore,
        Blocks.lit_redstone_ore, Blocks.quartz_ore, Blocks.redstone_ore, Blocks.wooden_pressure_plate,
        Blocks.stone_pressure_plate, Blocks.light_weighted_pressure_plate, Blocks.heavy_weighted_pressure_plate,
        Blocks.stone_button, Blocks.wooden_button, Blocks.lever, Blocks.tallgrass, Blocks.tripwire,
        Blocks.tripwire_hook, Blocks.rail, Blocks.waterlily, Blocks.red_flower, Blocks.red_mushroom,
        Blocks.brown_mushroom, Blocks.vine, Blocks.trapdoor, Blocks.yellow_flower, Blocks.ladder, Blocks.furnace,
        Blocks.sand, Blocks.cactus, Blocks.dispenser, Blocks.dropper, Blocks.crafting_table,
        Blocks.pumpkin, Blocks.sapling, Blocks.cobblestone_wall, Blocks.oak_fence, Blocks.activator_rail,
        Blocks.detector_rail, Blocks.golden_rail, Blocks.redstone_torch, Blocks.acacia_stairs, Blocks.birch_stairs,
        Blocks.brick_stairs, Blocks.dark_oak_stairs, Blocks.jungle_stairs, Blocks.nether_brick_stairs,
        Blocks.oak_stairs, Blocks.quartz_stairs, Blocks.red_sandstone_stairs, Blocks.sandstone_stairs,
        Blocks.spruce_stairs, Blocks.stone_brick_stairs, Blocks.stone_stairs, Blocks.double_wooden_slab,
        Blocks.stone_slab, Blocks.double_stone_slab, Blocks.stone_slab2, Blocks.double_stone_slab2, Blocks.web,
        Blocks.gravel, Blocks.daylight_detector_inverted, Blocks.daylight_detector, Blocks.soul_sand, Blocks.piston,
        Blocks.piston_extension, Blocks.piston_head, Blocks.sticky_piston, Blocks.iron_trapdoor, Blocks.ender_chest,
        Blocks.end_portal, Blocks.end_portal_frame, Blocks.standing_banner, Blocks.wall_banner, Blocks.deadbush,
        Blocks.slime_block, Blocks.acacia_fence_gate, Blocks.birch_fence_gate, Blocks.dark_oak_fence_gate,
        Blocks.jungle_fence_gate, Blocks.spruce_fence_gate, Blocks.oak_fence_gate
    )

    fun isValidStack(stack: ItemStack): Boolean {
        return when {
            stack.item is ItemBlock && isGoodBlockStack(stack) -> true
            stack.item is ItemPotion && isBuffPotion(stack) -> true
            stack.item is ItemFood && isGoodFood(stack) -> true
            stack.item is ItemEgg || stack.item is ItemSnowball -> true
            else -> stack.item == Items.arrow ||
                    stack.item is ItemFishingRod ||
                    stack.item is ItemEnderPearl ||
                    stack.item == Items.water_bucket
        }
    }

    fun isBuffPotion(stack: ItemStack): Boolean {
        val potion = stack.item as ItemPotion
        val effects = potion.getEffects(stack)
        val BAD_EFFECTS_IDS = listOf(Potion.poison.id, Potion.weakness.id, Potion.wither.id, Potion.blindness.id, Potion.digSlowdown.id, Potion.harm.id)
        return effects.isNotEmpty() && effects.none { it.potionID in BAD_EFFECTS_IDS }
    }

    fun isGoodFood(stack: ItemStack): Boolean {
        val food = stack.item as ItemFood
        return food is ItemAppleGold || (food.getHealAmount(stack) >= 4 && food.getSaturationModifier(stack) >= 0.3f)
    }

    fun isGoodBlockStack(stack: ItemStack): Boolean {
        return stack.stackSize >= 1 && !blacklistedBlocks.contains(Block.getBlockFromItem(stack.item))
    }

    fun isInventoryEmpty(inventory: IInventory): Boolean {
        for (i in 0 until inventory.sizeInventory) {
            val stack = inventory.getStackInSlot(i) ?: continue
            if (isValidStack(stack)) return false
        }
        return true
    }

    fun isInventoryFull(): Boolean {
        for (i in 9 until 45) {
            if (!mc.thePlayer.inventoryContainer.getSlot(i).hasStack) return false
        }
        return true
    }

    fun findBestBlockStack(): Int {
        var bestSlot = -1
        var blockCount = -1
        for (i in 44 downTo 9) {
            val stack = mc.thePlayer.inventoryContainer.getSlot(i).stack
            if (stack != null && stack.item is ItemBlock && isGoodBlockStack(stack) && stack.stackSize > blockCount) {
                bestSlot = i
                blockCount = stack.stackSize
            }
        }
        return bestSlot
    }



    fun getItemStack(command: String): ItemStack {
        return try {
            var input = command.replace('&', '§')
            val args = input.split(" ").toTypedArray()
            var i = 1
            var j = 0
            val resourcelocation = ResourceLocation(args[0])
            val item = Item.itemRegistry.getObject(resourcelocation)
            if (args.size >= 2 && args[1].matches(Regex("\\d+"))) i = args[1].toInt()
            if (args.size >= 3 && args[2].matches(Regex("\\d+"))) j = args[2].toInt()
            val itemstack = ItemStack(item, i, j)
            if (args.size >= 4) {
                val NBT = StringBuilder()
                for (k in 3 until args.size) NBT.append(" ").append(args[k])
                itemstack.setTagCompound(JsonToNBT.getTagFromJson(NBT.toString()))
            }
            itemstack
        } catch (ex: Exception) {
            ex.printStackTrace()
            ItemStack(Blocks.barrier)
        }
    }
}
