package net.bloom.bloomclient.utils.player

import net.bloom.bloomclient.utils.Constants
import net.minecraft.block.BlockBush
import net.minecraft.block.BlockSlime
import net.minecraft.client.MinecraftInstance
import net.minecraft.enchantment.EnchantmentHelper
import net.minecraft.enchantment.Enchantments
import net.minecraft.init.Blocks
import net.minecraft.init.Items
import net.minecraft.item.*

object InventoryUtils: MinecraftInstance() {
    fun findItem(start: Int, end: Int, predict: (ItemStack, Item) -> Boolean): SlotData? {
        for (i in start..end) {
            val stack = mc.thePlayer.inventoryContainer.getSlot(i).stack ?: continue
            val item = stack.item

            if (predict(stack, item))
                return SlotData(i, stack, item)
        }

        return null
    }

    fun findItem(start: Int, end: Int, itemNeed: Item) = findItem(start, end) { _, item -> item == itemNeed }

    fun findBlockSlotInHotbar(): Int {
        var item = -1
        var stacksize = 0

        val heldItem = mc.thePlayer.heldItem?.item

        if (heldItem != null && heldItem is ItemBlock && !Constants.INVENTORIES_INVALID_ITEMS.contains(heldItem.block))
            return mc.thePlayer.inventory.currentItem

        for (i in 36..44) {
            val stack = mc.thePlayer.inventoryContainer.getSlot(i).stack
            val stackItem = stack?.item

            if (stackItem is ItemBlock && !Constants.INVENTORIES_INVALID_ITEMS.contains(stackItem.block) && stack.stackSize >= stacksize) {
                item = i - 36
                stacksize = stack.stackSize
            }
        }

        return item
    }

    fun findBlockSlotInInventory(): ItemStack? {
        var item: ItemStack? = null
        var stacksize = 0

        val heldItem = mc.thePlayer.heldItem?.item

        if (heldItem is ItemBlock && !Constants.INVENTORIES_INVALID_ITEMS.contains(heldItem.block))
            return mc.thePlayer.heldItem

        for (i in 9..44) {
            val stack = mc.thePlayer.inventoryContainer.getSlot(i).stack
            val stackItem = stack?.item

            if (stackItem is ItemBlock && !Constants.INVENTORIES_INVALID_ITEMS.contains(stackItem.block) && stack.stackSize >= stacksize) {
                item = stack
                stacksize = stack.stackSize
            }
        }

        return item
    }

    fun findProjectileItemSlotInHotbar(): Int {
        for (i in 36..44) {
            val itemStack = mc.thePlayer.inventoryContainer.getSlot(i).stack

            if (itemStack.item is ItemSnowball || itemStack.item is ItemEgg || itemStack.item is ItemFishingRod)
                return i - 36
        }

        return -1
    }

    fun findProjectileItemSlotInInventory(): ItemStack? {
        var item: ItemStack? = null
        var stacksize = 0

        for (i in 9..44) {
            val itemStack = mc.thePlayer.inventoryContainer.getSlot(i).stack

            if (itemStack != null && (itemStack.item is ItemSnowball || itemStack.item is ItemEgg || itemStack.item is ItemFishingRod) && itemStack.stackSize >= stacksize) {
                item = itemStack
                stacksize = itemStack.stackSize
            }
        }

        return item
    }

    fun calculateProtection(stack: ItemStack): Float {
        var protecion = 0f

        val item = stack.item

        if (item is ItemArmor) {
            val protectionLvl = EnchantmentHelper.getEnchantmentLevel(Enchantments.protection.effectId, stack)
            val blastProtectionLvl = EnchantmentHelper.getEnchantmentLevel(Enchantments.blastProtection.effectId, stack)
            val fireProtectionLvl = EnchantmentHelper.getEnchantmentLevel(Enchantments.fireProtection.effectId, stack)
            val thornsLvl = EnchantmentHelper.getEnchantmentLevel(Enchantments.fireProtection.effectId, stack)
            val unbreakingLvl = EnchantmentHelper.getEnchantmentLevel(Enchantments.unbreaking.effectId, stack)

            protecion += item.damageReduceAmount + ((100 - item.damageReduceAmount) * protectionLvl) * 0.0075f
            protecion += blastProtectionLvl / 100f
            protecion += fireProtectionLvl / 100f
            protecion += thornsLvl / 100f
            protecion += unbreakingLvl / 50f
            protecion += protecion / 100f
        }

        return protecion
    }

    fun isBestArmor(stack: ItemStack, type: Int): Boolean {
        val protection = calculateProtection(stack)
        val strType = when (type) {
            1 -> "helmet"
            2 -> "chestplate"
            3 -> "leggings"
            4 -> "boots"
            else -> ""
        }

        if (!stack.unlocalizedName.contains(strType))
            return false

        for (i in 5..44) {
            if (mc.thePlayer.inventoryContainer.getSlot(i).hasStack) {
                val itemStack = mc.thePlayer.inventoryContainer.getSlot(i).stack

                if (calculateProtection(itemStack) > protection && itemStack.unlocalizedName.contains(strType))
                    return false
            }
        }
        return true
    }

    fun findFireballInHotbar(): Int? {
        val player = mc.thePlayer ?: return null
        val inventory = player.openContainer

        return (36..44).firstOrNull {
            val stack = inventory.getSlot(it).stack ?: return@firstOrNull false
            stack.item is ItemFireball && stack.stackSize > 0
        }
    }

    fun findFireballSlot(): Int? {
        return (0..8).firstOrNull {
            val stack = mc.thePlayer.inventory.getStackInSlot(it)
            stack?.item is ItemFireball
        }
    }

    fun findLargestBlockForScaffoldInHotbar(): Int? {
        val player = mc.thePlayer ?: return null
        val inventory = player.openContainer

        return (36..44).filter {
            val stack = inventory.getSlot(it).stack ?: return@filter false
            val block = if (stack.item is ItemBlock) (stack.item as ItemBlock).block else return@filter false

            stack.item is ItemBlock && stack.stackSize > 0 && block.isFullCube && block !in Constants.SCAFFOLD_BLOCK_BLACKLIST && block !is BlockBush
        }.maxByOrNull { inventory.getSlot(it).stack.stackSize }
    }

    fun hasSpaceInHotbar(): Boolean {
        for (i in 36..44)
            mc.thePlayer.inventoryContainer.getSlot(i).stack ?: return true

        return false
    }

    fun isBadStack(itemStack: ItemStack, preferSword: Boolean, keepTools: Boolean): Boolean {
        for (type in 1..4) {
            val strType = when (type) {
                1 -> "helmet"
                2 -> "chestplate"
                3 -> "leggings"
                4 -> "boots"
                else -> ""
            }

            if (itemStack.item is ItemArmor && !isBestArmor(itemStack, type) && itemStack.unlocalizedName.contains(strType))
                return true

            val stack = mc.thePlayer.inventoryContainer.getSlot(4 + type).stack

            if (stack != null && isBestArmor(stack, type) && stack.unlocalizedName.contains(strType) && itemStack.unlocalizedName.contains(strType))
                return true
        }

        if (itemStack.item is ItemSword && bestSword != itemStack)
            return true

        if (itemStack.item is ItemBow && bestBow != itemStack)
            return true

        if (keepTools) {
            if (itemStack.item is ItemAxe && itemStack != bestAxe && (preferSword || bestWeapon != itemStack))
                return true


            if (itemStack.item is ItemPickaxe && itemStack != bestPickaxe && (preferSword || bestWeapon != itemStack))
                return true


            if (itemStack.item is ItemSpade && itemStack != bestShovel)
                return true

        } else {
            if (itemStack.item is ItemAxe && (preferSword || bestWeapon != itemStack))
                return true


            if (itemStack.item is ItemPickaxe && (preferSword || bestWeapon != itemStack ))
                return true


            if (itemStack.item is ItemSpade)
                return true
        }

        return false
    }

    fun getBestTool(isSword: Boolean, isBow: Boolean, condition: (Item) -> Boolean): ItemStack? {
        var bestWeapon: ItemStack? = null
        var itemDamage = -1f

        for (i in 9..44) {
            val itemStack = mc.thePlayer.inventoryContainer.getSlot(i).stack ?: continue

            if (condition(itemStack.item)) {
                val toolDamage = if (isBow) getBowDamage(itemStack) else if (isSword) getItemDamage(itemStack) else getToolRating(itemStack)

                if (toolDamage >= itemDamage) {
                    itemDamage = toolDamage
                    bestWeapon = itemStack
                }
            }
        }

        return bestWeapon
    }

    private val bestWeapon: ItemStack?
        get() = getBestTool(isSword = true, isBow = true) { it is ItemSword || it is ItemAxe || it is ItemPickaxe }

    private val bestSword: ItemStack?
        get() = getBestTool(isSword = true, isBow = true) { it is ItemSword }

    private val bestBow: ItemStack?
        get() = getBestTool(isSword = false, isBow = true) { it is ItemBow }

    private val bestAxe: ItemStack?
        get() = getBestTool(isSword = false, isBow = false) { it is ItemAxe }

    private val bestPickaxe: ItemStack?
        get() = getBestTool(isSword = false, isBow = false) { it is ItemPickaxe }

    private val bestShovel: ItemStack?
        get() = getBestTool(isSword = false, isBow = false) { it is ItemSpade }

    fun getToolRating(itemStack: ItemStack): Float {
        var damage = getToolMaterialRating(itemStack, false)
        damage += EnchantmentHelper.getEnchantmentLevel(Enchantments.efficiency.effectId, itemStack) * 2.00f
        damage += EnchantmentHelper.getEnchantmentLevel(Enchantments.silkTouch.effectId, itemStack) * 0.50f
        damage += EnchantmentHelper.getEnchantmentLevel(Enchantments.fortune.effectId, itemStack) * 0.50f
        damage += EnchantmentHelper.getEnchantmentLevel(Enchantments.unbreaking.effectId, itemStack) * 0.10f
        damage += (itemStack.maxDamage - itemStack.itemDamage) * 0.000000000001f
        return damage
    }

    fun getItemDamage(itemStack: ItemStack): Float {
        var damage = getToolMaterialRating(itemStack, true)
        damage += EnchantmentHelper.getEnchantmentLevel(Enchantments.sharpness.effectId, itemStack) * 1.25f
        damage += EnchantmentHelper.getEnchantmentLevel(Enchantments.fireAspect.effectId, itemStack) * 0.50f
        damage += EnchantmentHelper.getEnchantmentLevel(Enchantments.unbreaking.effectId, itemStack) * 0.01f
        damage += (itemStack.maxDamage - itemStack.itemDamage) * 0.000000000001f

        if (itemStack.item is ItemSword)
            damage += 0.2.toFloat()

        return damage
    }

    fun getBowDamage(itemStack: ItemStack): Float {
        var damage = 5f
        damage += EnchantmentHelper.getEnchantmentLevel(Enchantments.power.effectId, itemStack) * 1.25f
        damage += EnchantmentHelper.getEnchantmentLevel(Enchantments.punch.effectId, itemStack) * 0.75f
        damage += EnchantmentHelper.getEnchantmentLevel(Enchantments.flame.effectId, itemStack) * 0.50f
        damage += EnchantmentHelper.getEnchantmentLevel(Enchantments.unbreaking.effectId, itemStack) * 0.10f
        damage += itemStack.maxDamage - itemStack.itemDamage * 0.001f
        return damage
    }

    fun getToolMaterialRating(itemStack: ItemStack, checkForDamage: Boolean): Float {
        val item = itemStack.item
        var rating = 0f

        when (item) {
            is ItemSword -> {
                when (item.toolMaterialName) {
                    "WOOD" -> rating = 4f
                    "GOLD" -> rating = 4f
                    "STONE" -> rating = 5f
                    "IRON" -> rating = 6f
                    "EMERALD" -> rating = 7f
                }
            }

            is ItemPickaxe -> {
                when (item.toolMaterialName) {
                    "WOOD" -> rating = 2f
                    "GOLD" -> rating = 2f
                    "STONE" -> rating = 3f
                    "IRON" -> rating = (if (checkForDamage) 4 else 40).toFloat()
                    "EMERALD" -> rating = (if (checkForDamage) 5 else 50).toFloat()
                }
            }

            is ItemAxe -> {
                when (item.toolMaterialName) {
                    "WOOD" -> rating = 3f
                    "GOLD" -> rating = 3f
                    "STONE" -> rating = 4f
                    "IRON" -> rating = 5f
                    "EMERALD" -> rating = 6f
                }
            }

            is ItemSpade -> {
                when (item.toolMaterialName) {
                    "WOOD" -> rating = 1f
                    "GOLD" -> rating = 1f
                    "STONE" -> rating = 2f
                    "IRON" -> rating = 3f
                    "EMERALD" -> rating = 4f
                }
            }
        }

        return rating
    }

    fun getBestWeaponSlotForAttacking(): Int {
        val (slot, _) = (0..8)
            .map { Pair(it, mc.thePlayer.inventory.getStackInSlot(it)) }
            .filter { it.second != null && (it.second.item is ItemSword || it.second.item is ItemTool) }
            .maxByOrNull { it.second.getAttributeModifierAmount("generic.attackDamage") + 1.25 * it.second.getEnchantLevel(Enchantments.sharpness) } ?: return -1

        return slot
    }

    // ---- Slot Spoof ----
    private var spoofedSlot = -1
    var spoofing = false
        private set

    fun startSpoofing(slot: Int) {
        spoofedSlot = slot
        spoofing = true
    }

    fun stopSpoofing() {
        spoofing = false
        spoofedSlot = -1
    }

    fun getSpoofedSlot(): Int {
        return if (spoofing) spoofedSlot else mc.thePlayer.inventory.currentItem
    }

    fun getSpoofedStack(): ItemStack? {
        return if (spoofing) {
            mc.thePlayer.inventory.getStackInSlot(spoofedSlot)
        } else {
            mc.thePlayer.heldItem
        }
    }


    data class SlotData(val slot: Int, val itemStack: ItemStack, val item: Item)
}